/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.commons.dto;

import com.dtyunxi.cube.commons.dto.TreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeDto<T extends TreeNode>
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(TreeDto.class);
    private T node;
    private List<TreeDto<T>> children;

    public TreeDto() {
    }

    public TreeDto(T node) {
        this.node = node;
    }

    public T getNode() {
        return this.node;
    }

    public void setNode(T node) {
        this.node = node;
    }

    public List<TreeDto<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeDto<T>> children) {
        this.children = children;
    }

    public static <T extends TreeNode> List<TreeDto<T>> createTreeDto(List<T> listT) {
        ArrayList<TreeDto<T>> treeDtos = new ArrayList<TreeDto<T>>();
        Long topId = TreeDto.findTopId(listT);
        if (!CollectionUtils.isEmpty(listT)) {
            HashMap<String, List<TreeDto<T>>> subCatalogMap = new HashMap<String, List<TreeDto<T>>>();
            for (TreeNode treeNode : listT) {
                TreeDto<TreeNode> treeDto = new TreeDto<TreeNode>(treeNode);
                if (topId.equals(treeNode.getParentId())) {
                    treeDtos.add(treeDto);
                    continue;
                }
                String parentIdString = String.valueOf(treeNode.getParentId());
                ArrayList<TreeDto<TreeNode>> subList = (ArrayList<TreeDto<TreeNode>>)subCatalogMap.get(parentIdString);
                if (CollectionUtils.isEmpty((Collection)subList)) {
                    subList = new ArrayList<TreeDto<TreeNode>>();
                }
                subList.add(treeDto);
                subCatalogMap.put(parentIdString, subList);
            }
            for (TreeDto treeDto : treeDtos) {
                TreeDto.getSubCatalog(treeDto, subCatalogMap);
            }
        }
        return treeDtos;
    }

    private static <T extends TreeNode> void getSubCatalog(TreeDto<T> parentCatalog, Map<String, List<TreeDto<T>>> map) {
        String parentIdString = String.valueOf(parentCatalog.getNode().getId());
        List<TreeDto<T>> childList = map.get(parentIdString);
        if (!CollectionUtils.isEmpty(childList)) {
            parentCatalog.setChildren(childList);
            for (TreeDto<T> child : childList) {
                TreeDto.getSubCatalog(child, map);
            }
        }
    }

    private static <T extends TreeNode> Long findTopId(List<T> list) {
        Long topId = null;
        for (TreeNode t : list) {
            if (t == null || t.getParentId() == null) continue;
            if (topId == null) {
                topId = t.getParentId();
                continue;
            }
            if (t.getParentId().equals(TreeNode.TOP_ID)) {
                topId = t.getParentId();
                return topId;
            }
            if (!topId.equals(t.getId())) continue;
            topId = t.getParentId();
        }
        if (topId == null) {
            topId = 0L;
        }
        return topId;
    }
}

