/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.dtyunxi.app.AbstractBoot;
import com.dtyunxi.cube.framework.config.CustomLocalDateTimeDeserializer;
import com.dtyunxi.cube.framework.config.SpringEnhanceConfig;
import com.dtyunxi.cube.framework.interceptor.RestInterceptor;
import com.dtyunxi.http.converter.JsLongFastJsonHttpMessageConverter;
import com.dtyunxi.huieryun.log.LoggerServletFilter;
import com.dtyunxi.util.SpringBeanUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Import(value={SpringEnhanceConfig.class})
public class RestAppConfig
implements WebMvcConfigurer {
    private final List<RestInterceptor> interceptors = new ArrayList<RestInterceptor>();
    private static ApplicationContext ctx;
    @Value(value="${cube.response.enable-null-field:true}")
    private Boolean enableNullResponse = true;
    @Value(value="${cube.json.date-format:yyyy-MM-dd HH:mm:ss}")
    private String jsonDateFormat;
    @Value(value="${cube.json.time-zone:GMT+8}")
    private String jsonTimeZone;

    @Deprecated
    protected FastJsonHttpMessageConverter customConverters() {
        JsLongFastJsonHttpMessageConverter fastJsonMsgConvert = new JsLongFastJsonHttpMessageConverter();
        Charset UTF8 = StandardCharsets.UTF_8;
        fastJsonMsgConvert.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)));
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        if (this.enableNullResponse.booleanValue()) {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue});
        } else {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
        }
        fastJsonMsgConvert.setFastJsonConfig(fastJsonConfig);
        return fastJsonMsgConvert;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)this.customConverters());
    }

    @Bean
    @ConditionalOnProperty(prefix="cube.json", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
        return builder -> {
            builder.failOnUnknownProperties(false).serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance).serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance).serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(this.jsonDateFormat))).deserializerByType(LocalDateTime.class, (JsonDeserializer)CustomLocalDateTimeDeserializer.instance);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.jsonDateFormat);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.jsonTimeZone));
            builder.dateFormat((DateFormat)simpleDateFormat);
            if (!this.enableNullResponse.booleanValue()) {
                builder.serializationInclusion(JsonInclude.Include.NON_NULL);
            }
        };
    }

    public void configurePathMatch(PathMatchConfigurer matcher) {
        matcher.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        this.interceptors.forEach(item -> {
            InterceptorRegistration res = registry.addInterceptor((HandlerInterceptor)item);
            if (item.includePath().length > 0) {
                res.addPathPatterns(item.includePath());
            }
            if (item.excludePath().length > 0) {
                res.excludePathPatterns(item.excludePath());
            }
        });
    }

    public void addInterceptor(RestInterceptor ... item) {
        if (item != null) {
            this.interceptors.addAll(Arrays.asList(item));
        }
    }

    protected static void runApp(Class<?> app, String[] args) throws Exception {
        ctx = new AbstractBoot((Class)app, args){

            @Override
            public void execute() throws Exception {
                LoggerServletFilter.initLogger();
            }
        }.run();
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    @Bean
    @ConditionalOnMissingBean(name={"loggerServletFilter"})
    public LoggerServletFilter loggerServletFilter() {
        return new LoggerServletFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBeanUtil"})
    public SpringBeanUtil springBeanUtil() {
        return new SpringBeanUtil();
    }
}

