/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class CustomLocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public static final CustomLocalDateTimeDeserializer instance = new CustomLocalDateTimeDeserializer();

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        LocalDateTimeMeta meta = this.getMeta(jsonParser.getText());
        if (meta.getType() == 1) {
            return new LocalDateTimeDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
        }
        LocalDate localDate = new LocalDateDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
        return localDate.atStartOfDay();
    }

    private LocalDateTimeMeta getMeta(String value) {
        boolean isTight;
        LocalDateTimeMeta defaultMeta = new LocalDateTimeMeta(1, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        if (value == null) {
            return defaultMeta;
        }
        LocalDateTimeMeta meta = defaultMeta;
        value = value.trim();
        int len = value.length();
        boolean hasDash = value.contains("-");
        boolean hasSlash = value.contains("/");
        boolean hasSpace = value.contains(" ");
        boolean hasColon = value.contains(":");
        boolean hasT = value.contains("T");
        boolean bl = isTight = !hasSlash && !hasDash && !hasSpace && !hasColon && hasT;
        if (len >= 6) {
            if (isTight && len == 8) {
                meta = new LocalDateTimeMeta(2, "yyyyMMdd");
            } else if (isTight && len == 14) {
                meta = new LocalDateTimeMeta(1, "yyyyMMddHHmmss");
            } else if (!isTight && len >= 8 && len <= 10 && hasDash) {
                meta = new LocalDateTimeMeta(2, "yyyy-MM-dd");
            } else if (!isTight && len >= 8 && len <= 10 && hasSlash) {
                meta = new LocalDateTimeMeta(2, "yyyy/MM/dd");
            } else if (!isTight && len > 10 && len <= 19 && hasDash && hasColon) {
                meta = new LocalDateTimeMeta(1, "yyyy-MM-dd HH:mm:ss");
            } else if (!isTight && len > 10 && len <= 19 && hasSlash && hasColon) {
                meta = new LocalDateTimeMeta(1, "yyyy/MM/dd HH:mm:ss");
            }
        }
        return meta;
    }

    public static class LocalDateTimeMeta {
        public static final int TYPE_LOCAL_DATETIME = 1;
        public static final int TYPE_LOCAL_DATE = 2;
        private int type;
        private DateTimeFormatter formatter;

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public DateTimeFormatter getFormatter() {
            return this.formatter;
        }

        public void setFormatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        LocalDateTimeMeta(int type, DateTimeFormatter formatter) {
            this.type = type;
            this.formatter = formatter;
        }

        LocalDateTimeMeta(int type, String style) {
            this.type = type;
            this.formatter = DateTimeFormatter.ofPattern(style);
        }
    }
}

