/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.app;

import com.dtyunxi.app.DeployEnv;
import com.dtyunxi.app.processor.DubboProcessor;
import com.dtyunxi.app.processor.EdasProcessor;
import com.dtyunxi.app.processor.EmptyProcessor;
import com.dtyunxi.app.processor.IProcessor;
import com.dtyunxi.app.processor.K8sProcessor;
import com.dtyunxi.app.processor.SpringCloudProcessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractBoot {
    private Class<?> source;
    private String[] args;
    private static Map<String, IProcessor> ENV_PROCESSORS = new HashMap<String, IProcessor>();

    public AbstractBoot(Class<?> source, String ... args) {
        this.source = source;
        this.args = args;
    }

    public static void appendDeployType(String deploy, IProcessor processor) {
        if (ENV_PROCESSORS.get(deploy) == null) {
            ENV_PROCESSORS.put(deploy, processor);
        }
    }

    public ConfigurableApplicationContext run() throws Exception {
        String deploy = System.getProperty("dtyunxi.deploy");
        System.out.println("[DTYUNXI BOOT] deploy=" + deploy);
        System.out.println("[DTYUNXI BOOT] DeployEnv=" + DeployEnv.getDeployEnv());
        if (StringUtils.isNotEmpty((CharSequence)deploy)) {
            deploy = deploy.toLowerCase();
        }
        this.setDiscoveryServer();
        IProcessor processor = ENV_PROCESSORS.getOrDefault(deploy, new EmptyProcessor());
        processor.preExecute(this.args);
        this.execute();
        ConfigurableApplicationContext applicationContext = processor.postExecute(this.source, this.args);
        return applicationContext;
    }

    private void setDiscoveryServer() {
        String discoveryServer = System.getProperty("dtyunxi.discovery.server");
        if (discoveryServer != null) {
            if (DeployEnv.isEdas()) {
                System.setProperty("vipserver.server.port", discoveryServer);
            } else if (DeployEnv.isSpringCloudPure()) {
                System.setProperty("eureka.client.serviceUrl.defaultZone", discoveryServer);
            }
        }
    }

    public abstract void execute() throws Exception;

    static {
        ENV_PROCESSORS.put("dubbo", new DubboProcessor());
        EdasProcessor edasProcessor = new EdasProcessor();
        ENV_PROCESSORS.put("k8s", new K8sProcessor());
        ENV_PROCESSORS.put("springcloud", new SpringCloudProcessor());
        ENV_PROCESSORS.put("edas", edasProcessor);
        ENV_PROCESSORS.put("edas_hsf", edasProcessor);
        ENV_PROCESSORS.put("edas_springcloud", edasProcessor);
    }
}

