CREATE TABLE IF NOT EXISTS `meta_entity_relation` (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `name` varchar(64) NOT NULL COMMENT '关系名称',
  `entity_code_a` varchar(64) DEFAULT NULL COMMENT '关系其中一端的实体a编码',
  `attr_code_a` varchar(64) DEFAULT NULL COMMENT '关系其中一端的实体a属性编码',
  `cardinality_a2b` varchar(20) DEFAULT NULL COMMENT '实体a相对实体b的关系基数:0..1;1..1;0..n;n..n',
  `entity_code_b` varchar(64) DEFAULT NULL COMMENT '关系其中一端的实体b编码',
  `attr_code_b` varchar(64) DEFAULT NULL COMMENT '关系其中一端的实体b属性编码',
  `cardinality_b2a` varchar(20) DEFAULT NULL COMMENT '实体b相对实体a的关系基数:0..1;1..1;0..n;n..n',
  `ref_entity_code` varchar(128) DEFAULT NULL COMMENT '中间表实体编码',
  `ref_attr_code_a` varchar(64) DEFAULT NULL COMMENT '中间表实体a属性编码',
  `ref_attr_code_b` varchar(64) DEFAULT NULL COMMENT '中间表实体b属性编码',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT '0' COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_ref_code` (`entity_code_a`,`attr_code_a`,`entity_code_b`,`attr_code_b`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='元数据实体关系表';