/**
 * @(#)I${className}Api.java 1.0 ${generateTime}
 *
 * Copyright (c) ${generateYear}, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ${packageName}.api.query;

import com.dtyunxi.rest.RestResponse;
import ${packageName}.api.dto.request.${className}QueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* ${tableComment}服务接口
*
* @author 代码生成器
* @Date : ${generateTime}
*/
@Api(tags = {"${tableComment}服务"})
@FeignClient(contextId="${contextPrefix}-api-query-I${className}QueryApi",name = "${feignName}", path = "${path}", url = "${feignUrl}")
public interface I${className}QueryApi {

    /**
    * 根据id查询${tableComment}
    *
    * @param id ${tableComment}id
    * @return   ${tableComment}数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询${tableComment}", notes = "根据id查询${tableComment}")
    RestResponse<${className}RespDto> queryById(@PathVariable("id") Long id);

    /**
    * ${tableComment}分页数据
    *
    * @param filter   ${tableComment}查询条件
    * @param pageNum 当前页
    * @param pageSize 页大小
    * @return ${tableComment}分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "${tableComment}分页数据", notes = "根据filter查询条件查询${tableComment}数据")
    RestResponse<PageInfo<${className}RespDto>> queryByPage(@SpringQueryMap ${className}QueryReqDto queryReqDto,
                                                            @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);
}
