/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.dtyunxi.cube.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IDCardUtil {
    private static final String MALE = "\u7537";
    private static final String FEMALE = "\u5973";
    private static final String UNKNOWN = "\u672a\u77e5";

    private IDCardUtil() {
    }

    public static boolean isIdCard(String cardNo) {
        String[] valCodeArr = new String[]{"1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2"};
        String[] wi = new String[]{"7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2"};
        String ai = "";
        if (cardNo.length() != 15 && cardNo.length() != 18) {
            return false;
        }
        if (cardNo.length() == 18) {
            ai = cardNo.substring(0, 17);
        } else if (cardNo.length() == 15) {
            ai = cardNo.substring(0, 6) + "19" + cardNo.substring(6, 15);
        }
        if (!IDCardUtil.isNumeric(ai)) {
            return false;
        }
        String strYear = ai.substring(6, 10);
        String strMonth = ai.substring(10, 12);
        String strDay = ai.substring(12, 14);
        if (!IDCardUtil.isDate(strYear + "-" + strMonth + "-" + strDay)) {
            System.out.println("\u751f\u65e5\u65e0\u6548\u3002");
            return false;
        }
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
        Date birthday = null;
        try {
            birthday = s.parse(strYear + "-" + strMonth + "-" + strDay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GregorianCalendar gc = new GregorianCalendar();
        if (gc.get(1) - Integer.parseInt(strYear) > 150 || gc.getTime().getTime() - birthday.getTime() < 0L) {
            return false;
        }
        if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
            return false;
        }
        if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
            return false;
        }
        Hashtable<String, String> h = IDCardUtil.getAreaCode();
        if (h.get(ai.substring(0, 2)) == null) {
            return false;
        }
        int totalmulAiWi = 0;
        for (int i = 0; i < 17; ++i) {
            totalmulAiWi += Integer.parseInt(String.valueOf(ai.charAt(i))) * Integer.parseInt(wi[i]);
        }
        int modValue = totalmulAiWi % 11;
        String strVerifyCode = valCodeArr[modValue];
        ai = ai + strVerifyCode;
        return cardNo.length() != 18 || ai.equalsIgnoreCase(cardNo);
    }

    private static Hashtable<String, String> getAreaCode() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("11", "\u5317\u4eac");
        hashtable.put("12", "\u5929\u6d25");
        hashtable.put("13", "\u6cb3\u5317");
        hashtable.put("14", "\u5c71\u897f");
        hashtable.put("15", "\u5185\u8499\u53e4");
        hashtable.put("21", "\u8fbd\u5b81");
        hashtable.put("22", "\u5409\u6797");
        hashtable.put("23", "\u9ed1\u9f99\u6c5f");
        hashtable.put("31", "\u4e0a\u6d77");
        hashtable.put("32", "\u6c5f\u82cf");
        hashtable.put("33", "\u6d59\u6c5f");
        hashtable.put("34", "\u5b89\u5fbd");
        hashtable.put("35", "\u798f\u5efa");
        hashtable.put("36", "\u6c5f\u897f");
        hashtable.put("37", "\u5c71\u4e1c");
        hashtable.put("41", "\u6cb3\u5357");
        hashtable.put("42", "\u6e56\u5317");
        hashtable.put("43", "\u6e56\u5357");
        hashtable.put("44", "\u5e7f\u4e1c");
        hashtable.put("45", "\u5e7f\u897f");
        hashtable.put("46", "\u6d77\u5357");
        hashtable.put("50", "\u91cd\u5e86");
        hashtable.put("51", "\u56db\u5ddd");
        hashtable.put("52", "\u8d35\u5dde");
        hashtable.put("53", "\u4e91\u5357");
        hashtable.put("54", "\u897f\u85cf");
        hashtable.put("61", "\u9655\u897f");
        hashtable.put("62", "\u7518\u8083");
        hashtable.put("63", "\u9752\u6d77");
        hashtable.put("64", "\u5b81\u590f");
        hashtable.put("65", "\u65b0\u7586");
        hashtable.put("71", "\u53f0\u6e7e");
        hashtable.put("81", "\u9999\u6e2f");
        hashtable.put("82", "\u6fb3\u95e8");
        hashtable.put("91", "\u56fd\u5916");
        return hashtable;
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    public static Date getBirthday(String cardNo) {
        Date date = null;
        date = cardNo.length() == 15 ? DateUtil.parseDate(cardNo.substring(6, 12), "yyMMdd") : DateUtil.parseDate(cardNo.substring(6, 14), "yyyyMMdd");
        return date;
    }

    public static String getBirthdayToString(String cardNo) {
        String date = null;
        date = cardNo.length() == 15 ? "19" + cardNo.substring(6, 12) : cardNo.substring(6, 14);
        return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
    }

    public static String getGendar(String cardNo) {
        if (cardNo.length() != 15 && cardNo.length() != 18) {
            return UNKNOWN;
        }
        if (cardNo.length() == 15) {
            int gendarFlag = new Integer(cardNo.substring(14, 15));
            return gendarFlag % 2 == 0 ? FEMALE : MALE;
        }
        int gendarFlag = new Integer(cardNo.substring(16, 17));
        return gendarFlag % 2 == 0 ? FEMALE : MALE;
    }
}

