/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomUtil {
    public static final String ALL_CHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ALL_CLEAR_CHAR = "2356789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    public static final String LETTER_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String NUMBER_CHAR = "0123456789";
    public static final String LOWER_LETTER_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPER_LETTER_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private RandomUtil() {
    }

    public static String generateString(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(ALL_CHAR.charAt(random.nextInt(ALL_CHAR.length())));
        }
        return sb.toString();
    }

    public static int getInt(int max) {
        Random random = new Random();
        return random.nextInt(max);
    }

    public static int getInt(int min, int max) {
        return RandomUtil.getInt(max - min) + min;
    }

    public static String generateString(String characterSet, int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(characterSet.charAt(random.nextInt(characterSet.length())));
        }
        return sb.toString();
    }

    public static String generateMixString(int length) {
        return RandomUtil.generateString(ALL_CHAR, length);
    }

    public static String generateNumberString(int length) {
        return RandomUtil.generateString(NUMBER_CHAR, length);
    }

    public static String generateLowerString(int length) {
        return RandomUtil.generateMixString(length).toLowerCase();
    }

    public static String generateUpperString(int length) {
        return RandomUtil.generateMixString(length).toUpperCase();
    }

    public static String generateZeroString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static String toFixdLengthString(long num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() < 0) {
            throw new RuntimeException("\u5c06\u6570\u5b57" + num + "\u8f6c\u5316\u4e3a\u957f\u5ea6\u4e3a" + fixdlenth + "\u7684\u5b57\u7b26\u4e32\u53d1\u751f\u5f02\u5e38\uff01");
        }
        sb.append(RandomUtil.generateZeroString(fixdlenth - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    public static String toFixdLengthString(int num, int fixdlenth) {
        StringBuffer sb = new StringBuffer();
        String strNum = String.valueOf(num);
        if (fixdlenth - strNum.length() < 0) {
            throw new RuntimeException("\u5c06\u6570\u5b57" + num + "\u8f6c\u5316\u4e3a\u957f\u5ea6\u4e3a" + fixdlenth + "\u7684\u5b57\u7b26\u4e32\u53d1\u751f\u5f02\u5e38\uff01");
        }
        sb.append(RandomUtil.generateZeroString(fixdlenth - strNum.length()));
        sb.append(strNum);
        return sb.toString();
    }

    public static Set<String> generateInBatches(String characterSet, int length, int num) {
        HashSet<String> set = new HashSet<String>();
        while (set.size() < num) {
            String s = RandomUtil.generateString(characterSet, length);
            set.add(s);
        }
        return set;
    }
}

