/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.codec;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base64;

public class KeyStoreUtil {
    public static final String KEY_STORE = "JKS";
    public static final String X509 = "X.509";
    private final KeyStore keyStore;

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    private KeyStoreUtil(KeyStore ks) {
        this.keyStore = ks;
    }

    public static KeyStoreUtil getKeyStore(InputStream is, String password) throws Exception {
        KeyStoreUtil kutil = new KeyStoreUtil(KeyStore.getInstance(KEY_STORE));
        kutil.getKeyStore().load(is, password.toCharArray());
        return kutil;
    }

    public static KeyStoreUtil getKeyStore(String keyStorePath, String password) throws Exception {
        KeyStoreUtil kutil = new KeyStoreUtil(KeyStore.getInstance(KEY_STORE));
        try (FileInputStream is = new FileInputStream(keyStorePath);){
            kutil.getKeyStore().load(is, password.toCharArray());
        }
        return kutil;
    }

    public PrivateKey getPrivateKey(String alias, String keyPass) throws Exception {
        PrivateKey key = (PrivateKey)this.keyStore.getKey(alias, keyPass.toCharArray());
        return key;
    }

    private PublicKey getPublicKey(String alias) throws Exception {
        PublicKey key = this.keyStore.getCertificate(alias).getPublicKey();
        return key;
    }

    public String getPublicKeyStr(String alias) throws Exception {
        PublicKey key = this.getPublicKey(alias);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public String getStrPrivateKey(String alias, String keyPass) throws Exception {
        PrivateKey key = this.getPrivateKey(alias, keyPass);
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }
}

