/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.net;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static SSLConnectionSocketFactory sslsf = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static SSLContextBuilder builder = null;
    private static final Logger Log = LoggerFactory.getLogger(HttpHelper.class);
    private boolean userPooling = true;
    private String encoding;

    public static CloseableHttpClient getHttpClient(boolean userPooling) {
        if (userPooling) {
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setConnectionManagerShared(true).build();
        }
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public HttpHelper() {
        this(Charsets.UTF_8.toString(), true);
    }

    public HttpHelper(String encoding, boolean userPooling) {
        this.encoding = encoding;
        this.userPooling = userPooling;
    }

    private String request(HttpUriRequest request) throws IOException {
        try (CloseableHttpClient httpclient = HttpHelper.getHttpClient(this.userPooling);){
            String string = this.request(request, httpclient);
            return string;
        }
    }

    private String request(HttpUriRequest request, CloseableHttpClient httpclient) throws IOException, ClientProtocolException {
        ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                Log.debug("httpRespone status:{}", (Object)status);
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity, (String)HttpHelper.this.encoding) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        };
        Log.debug("sending httpRequest:{} {}", (Object)request.getMethod(), (Object)request.getURI());
        String responseBody = (String)httpclient.execute(request, (ResponseHandler)responseHandler);
        Log.debug(" httprespone:{}", (Object)responseBody);
        return responseBody;
    }

    public String get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        return this.request((HttpUriRequest)get);
    }

    public String get(String url, String params) throws IOException {
        if (!Strings.isNullOrEmpty((String)params)) {
            url = url.concat("?").concat(params);
        }
        return this.get(url);
    }

    private String post(String url, List<NameValuePair> params) throws IOException {
        HttpPost post = new HttpPost(url);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, this.encoding);
        post.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)post);
    }

    public String post(String url, Map<String, String> params) throws IOException {
        ArrayList<BasicNameValuePair> np = null;
        if (params != null && params.size() > 0) {
            np = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                BasicNameValuePair tmp = new BasicNameValuePair(entry.getKey(), entry.getValue());
                np.add(tmp);
            }
        }
        return this.post(url, np);
    }

    public String post(String url, String rawContents) throws UnsupportedEncodingException, IOException {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(rawContents, this.encoding);
        post.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)post);
    }

    public String post(String url, String rawContents, Map<String, String> headers) throws UnsupportedEncodingException, IOException {
        HttpPost post = new HttpPost(url);
        headers.forEach((key, value) -> post.setHeader(key, value));
        StringEntity entity = new StringEntity(rawContents, this.encoding);
        post.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)post);
    }

    public String put(String url, String rawContents) throws UnsupportedEncodingException, IOException {
        HttpPut put = new HttpPut(url);
        StringEntity entity = new StringEntity(rawContents, this.encoding);
        put.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)put);
    }

    public String put(String url, Map<String, String> params) throws IOException {
        ArrayList<BasicNameValuePair> np = null;
        if (params != null && params.size() > 0) {
            np = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                BasicNameValuePair tmp = new BasicNameValuePair(entry.getKey(), entry.getValue());
                np.add(tmp);
            }
        }
        return this.put(url, np);
    }

    public String put(String url, String rawContents, Map<String, String> headers) throws UnsupportedEncodingException, IOException {
        HttpPut put = new HttpPut(url);
        headers.forEach((key, value) -> put.setHeader(key, value));
        StringEntity entity = new StringEntity(rawContents, this.encoding);
        put.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)put);
    }

    private String put(String url, List<NameValuePair> params) throws IOException {
        HttpPut post = new HttpPut(url);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, this.encoding);
        post.setEntity((HttpEntity)entity);
        return this.request((HttpUriRequest)post);
    }

    public String delete(String url) throws UnsupportedEncodingException, IOException {
        HttpDelete delete = new HttpDelete(url);
        return this.request((HttpUriRequest)delete);
    }

    public String delete(String url, String params) throws UnsupportedEncodingException, IOException {
        if (!Strings.isNullOrEmpty((String)params)) {
            url = url.concat("?").concat(params);
        }
        return this.delete(url);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    static {
        try {
            builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            });
            sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry registry = RegistryBuilder.create().register(HTTP, (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)sslsf).build();
            cm = new PoolingHttpClientConnectionManager(registry);
            cm.setMaxTotal(200);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }
}

