/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.redis;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.redis.RedisListener;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class JedisUtils {
    JedisPool jedisPool;
    JedisPubSub jedisPubSub = new JedisPubSub(){};

    public static JedisUtils Instance(String host) {
        return new JedisUtils(host);
    }

    private JedisUtils(String host) {
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host);
    }

    protected void finalize() throws Throwable {
        this.jedisPool.destroy();
        super.finalize();
    }

    public <T> void publish(String topic, T data) throws Exception {
        String send = ObjectHelper.bean2Json(data);
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.publish(topic, send);
        }
    }

    public void subscribe(RedisListener listener, String topic) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.subscribe((JedisPubSub)listener, new String[]{topic});
        }
    }
}

