/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.rules;

import com.dtyunxi.cube.utils.rules.RuleDetail;
import com.dtyunxi.cube.utils.rules.RuleExecException;
import com.dtyunxi.cube.utils.rules.RuleExecutor;
import com.dtyunxi.cube.utils.rules.RuleResultSet;
import com.googlecode.aviator.AviatorEvaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRuleExecutor
implements RuleExecutor {
    private static Logger logger = LoggerFactory.getLogger(DefaultRuleExecutor.class);

    @Override
    public RuleResultSet exec(List<RuleDetail> rules, Map<String, Object> globalVars) throws RuleExecException {
        this.checkRules(rules);
        Map<String, List<RuleDetail>> ruleGrouped = this.makeGroup(rules);
        RuleResultSet results = new RuleResultSet();
        for (Map.Entry<String, List<RuleDetail>> entry : ruleGrouped.entrySet()) {
            this.compute(results, entry.getKey(), entry.getValue(), globalVars);
        }
        return results;
    }

    @Override
    public RuleResultSet exec(RuleDetail rule, Map<String, Object> globalVars) throws RuleExecException {
        return this.exec(Arrays.asList(rule), globalVars);
    }

    @Override
    public RuleResultSet exec(RuleDetail rule) throws RuleExecException {
        return this.exec(Arrays.asList(rule), null);
    }

    @Override
    public RuleResultSet exec(List<RuleDetail> rules) throws RuleExecException {
        return this.exec(rules, null);
    }

    private void checkRules(List<RuleDetail> rules) throws RuleExecException {
        if (rules == null || rules.isEmpty()) {
            throw new RuleExecException("\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u89c4\u5219");
        }
    }

    private Map<String, List<RuleDetail>> makeGroup(List<RuleDetail> rules) {
        HashMap<String, List<RuleDetail>> ruleGrouped = new HashMap<String, List<RuleDetail>>();
        rules.forEach(rule -> {
            ArrayList<RuleDetail> details;
            String group = "";
            if (StringUtils.isNotEmpty((CharSequence)rule.exclusiveGroup)) {
                group = rule.exclusiveGroup;
            }
            if ((details = (ArrayList<RuleDetail>)ruleGrouped.get(group)) == null) {
                details = new ArrayList<RuleDetail>();
                ruleGrouped.put(group, details);
            }
            details.add((RuleDetail)rule);
        });
        return ruleGrouped;
    }

    private void compute(RuleResultSet results, String exclusiveGroup, List<RuleDetail> details, Map<String, Object> globalVars) {
        logger.info("compute rules of group < {} >", (Object)exclusiveGroup);
        HashMap<String, Object> expVars = new HashMap<String, Object>();
        if (globalVars != null) {
            expVars.putAll(globalVars);
        }
        for (RuleDetail rule : details) {
            boolean matched = false;
            for (String exp : rule.exps) {
                expVars.putAll(rule.vars);
                Object obj = AviatorEvaluator.execute((String)exp, expVars);
                logger.info("Eval rule\uff1a{} => {},result=>{}", new Object[]{rule.name, exp, obj});
                if ("none".equals(obj)) continue;
                results.add(rule.name, obj);
                rule.result = obj;
                matched = true;
                expVars.put(rule.getName(), obj);
                break;
            }
            if (!matched || !StringUtils.isNotEmpty((CharSequence)exclusiveGroup)) continue;
            logger.info("meet exclusiveGroup< {} >,stop", (Object)exclusiveGroup);
            break;
        }
    }
}

