/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.threads.pattens;

import com.dtyunxi.cube.utils.threads.pattens.ConsumerWorker;
import com.dtyunxi.cube.utils.threads.pattens.ProductStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerThread<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerThread.class);
    private ProductStore<T> prodStore;
    private boolean running;
    private ConsumerWorker worker;

    public ConsumerThread(ProductStore<T> prodStore, ConsumerWorker worker) {
        this.running = true;
        this.prodStore = prodStore;
        this.worker = worker;
    }

    public ConsumerThread() {
        this.running = false;
    }

    @Override
    public void run() {
        LOG.info("ConsumerThread Started....");
        while (this.running && !Thread.currentThread().isInterrupted()) {
            try {
                T prod = this.prodStore.pop();
                this.worker.doWork(prod);
                LOG.debug("polled product:{}", (Object)prod.toString());
            }
            catch (InterruptedException ex) {
                LOG.warn("ConsumerThread\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                break;
            }
        }
        LOG.info("ConsumerThread Stopped....");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public ProductStore<T> getProdStore() {
        return this.prodStore;
    }

    public void setProdStore(ProductStore<T> prodStore) {
        this.prodStore = prodStore;
    }

    public ConsumerWorker getWorker() {
        return this.worker;
    }

    public void setWorker(ConsumerWorker worker) {
        this.worker = worker;
    }
}

