/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.threads.pattens;

import com.dtyunxi.cube.utils.threads.pattens.ProductStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class ProductQueueStore<T>
implements ProductStore<T> {
    private BlockingQueue<T> msgQueue;

    public ProductQueueStore(int size) {
        this.msgQueue = new ArrayBlockingQueue<T>(size);
    }

    public ProductQueueStore() {
        this(10000);
    }

    @Override
    public void push(T msg) throws InterruptedException {
        if (!this.msgQueue.contains(msg)) {
            this.msgQueue.put(msg);
        }
    }

    @Override
    public T pop() throws InterruptedException {
        return this.msgQueue.take();
    }

    @Override
    public List<T> pop(int n) throws InterruptedException {
        Object prod = this.msgQueue.take();
        ArrayList<T> msgs = new ArrayList<T>();
        msgs.add(prod);
        for (int i = 1; i < n && null != (prod = this.msgQueue.poll()); ++i) {
            msgs.add(prod);
        }
        return msgs;
    }

    @Override
    public boolean isFull() {
        return this.msgQueue.remainingCapacity() > 0;
    }
}

