/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.security.Timestamp;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeBeanUtils {
    private static Logger logger = LoggerFactory.getLogger(CubeBeanUtils.class);
    private static Map<Class<?>, Object> simpleBeanTypeMap = CubeBeanUtils.getSimpleBeanTypeMap();

    public static void copyProperties(Object target, Object source, String ... ignoreProperties) {
        if (target == null || source == null) {
            logger.info("---------copyProperties-------target or source is null");
            return;
        }
        if (simpleBeanTypeMap.containsKey(target.getClass()) || simpleBeanTypeMap.containsKey(source.getClass())) {
            target = source;
            return;
        }
        PropertyDescriptor[] targetPds = PropertyUtils.getPropertyDescriptors(target.getClass());
        PropertyDescriptor[] sourcePds = PropertyUtils.getPropertyDescriptors(source.getClass());
        Map<String, PropertyDescriptor> descriptorMap = CubeBeanUtils.getDescriptorMap(sourcePds);
        ArrayList ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : new ArrayList();
        FeatureDescriptor sourcePd = null;
        Object value = null;
        try {
            for (PropertyDescriptor targetPd : targetPds) {
                Method readMethod;
                Method writeMethod = targetPd.getWriteMethod();
                if (writeMethod == null || ignoreList.contains(targetPd.getName()) || (sourcePd = descriptorMap.get(targetPd.getName())) == null || (readMethod = ((PropertyDescriptor)sourcePd).getReadMethod()) == null || null == (value = readMethod.invoke(source, new Object[0]))) continue;
                if (!simpleBeanTypeMap.containsKey(value.getClass())) {
                    if (value instanceof Collection) {
                        value = CubeBeanUtils.collectionCopy(targetPd, value);
                    } else if (value instanceof Map) {
                        value = CubeBeanUtils.mapCopy(targetPd, value);
                    } else {
                        Object newObj = value;
                        try {
                            newObj = writeMethod.getParameterTypes()[0].newInstance();
                            CubeBeanUtils.copyProperties(newObj, value, new String[0]);
                        }
                        catch (Exception e) {
                            logger.error("targetPd newInstance Exception:", (Throwable)e);
                        }
                        value = newObj;
                    }
                }
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
        }
        catch (Exception ex) {
            if (sourcePd != null && value != null) {
                Field field = null;
                try {
                    field = target.getClass().getDeclaredField(sourcePd.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append("copyProperties Exception==>>");
                errorMsg.append(" sourceClassName:{}").append(source == null ? "null" : source.getClass());
                errorMsg.append(", targetClassName:{}").append(target == null ? "null" : target.getClass());
                errorMsg.append(", fieldName:").append(sourcePd.getName());
                errorMsg.append(", sourceFieldClass:").append(value.getClass());
                errorMsg.append(", targetFieldClass:").append(field == null ? "null" : field.getType());
                throw new RuntimeException(errorMsg.toString());
            }
            logger.error("copyProperties Exception:", (Throwable)ex);
        }
    }

    private static Map<String, PropertyDescriptor> getDescriptorMap(PropertyDescriptor[] descriptors) {
        HashMap<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : descriptors) {
            descriptorMap.put(descriptor.getName(), descriptor);
        }
        return descriptorMap;
    }

    private static Object mapCopy(PropertyDescriptor descriptor, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Class genericClazz = CubeBeanUtils.getGenericClazz(descriptor, value.getClass(), 1);
        Map targetMap = null;
        targetMap = value.getClass().getSimpleName().contains("Persistent") ? Maps.newHashMap() : (Map)value.getClass().newInstance();
        Map sourceMap = (Map)value;
        Set keySet = sourceMap.keySet();
        for (Object key : keySet) {
            Object sourceObj = sourceMap.get(key);
            if (key == null || sourceObj == null) continue;
            Object newObj = genericClazz.newInstance();
            CubeBeanUtils.copyProperties(newObj, sourceObj, new String[0]);
            targetMap.put(key, newObj);
        }
        return targetMap;
    }

    private static Object collectionCopy(PropertyDescriptor descriptor, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Collection targetCollection = null;
        try {
            Class genericClazz = CubeBeanUtils.getGenericClazz(descriptor, value.getClass(), 0);
            Collection sourceCollection = (Collection)value;
            if (sourceCollection.isEmpty()) {
                return sourceCollection;
            }
            if (value.getClass().getSimpleName().contains("Persistent")) {
                if (value instanceof Set) {
                    targetCollection = Sets.newHashSet();
                } else if (value instanceof List) {
                    targetCollection = Lists.newArrayList();
                }
            } else {
                targetCollection = value.getClass().getSimpleName().contains("ArrayList") ? Lists.newArrayList() : (Collection)value.getClass().newInstance();
            }
            CubeBeanUtils.copyCollection(targetCollection, sourceCollection, genericClazz);
        }
        catch (Exception e) {
            logger.error("collectionCopy Exception:", (Throwable)e);
        }
        return targetCollection;
    }

    private static Class getGenericClazz(PropertyDescriptor descriptor, Class<?> clazz, int index) {
        Class genericClazz = clazz;
        Type fc = descriptor.getWriteMethod().getGenericParameterTypes()[0];
        if (fc != null && fc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)fc;
            genericClazz = (Class)pt.getActualTypeArguments()[index];
        }
        return genericClazz;
    }

    public static Map<Class<?>, Object> getSimpleBeanTypeMap() {
        if (simpleBeanTypeMap == null) {
            simpleBeanTypeMap = Maps.newHashMap();
            simpleBeanTypeMap.put(BigDecimal.class, null);
            simpleBeanTypeMap.put(BigInteger.class, null);
            simpleBeanTypeMap.put(Boolean.class, null);
            simpleBeanTypeMap.put(Byte.class, null);
            simpleBeanTypeMap.put(Character.class, null);
            simpleBeanTypeMap.put(Double.class, null);
            simpleBeanTypeMap.put(Float.class, null);
            simpleBeanTypeMap.put(Integer.class, null);
            simpleBeanTypeMap.put(Long.class, null);
            simpleBeanTypeMap.put(Short.class, null);
            simpleBeanTypeMap.put(String.class, null);
            simpleBeanTypeMap.put(Class.class, null);
            simpleBeanTypeMap.put(java.util.Date.class, null);
            simpleBeanTypeMap.put(LocalDateTime.class, null);
            simpleBeanTypeMap.put(Calendar.class, null);
            simpleBeanTypeMap.put(File.class, null);
            simpleBeanTypeMap.put(Date.class, null);
            simpleBeanTypeMap.put(Time.class, null);
            simpleBeanTypeMap.put(Timestamp.class, null);
            simpleBeanTypeMap.put(URL.class, null);
        }
        return simpleBeanTypeMap;
    }

    public static void copyCollection(Collection target, Collection source, Class<?> targetClazz) {
        if (CollectionUtils.isEmpty((Collection)source)) {
            return;
        }
        for (Object sourceObj : source) {
            if (simpleBeanTypeMap.containsKey(sourceObj.getClass())) {
                target.add(sourceObj);
                continue;
            }
            Object newObj = null;
            try {
                newObj = targetClazz.newInstance();
            }
            catch (Exception e) {
                logger.error("copyCollection newInstance Exception:", (Throwable)e);
                target.add(sourceObj);
                continue;
            }
            CubeBeanUtils.copyProperties(newObj, sourceObj, new String[0]);
            target.add(newObj);
        }
    }
}

