/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.codec;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class Coder {
    private static Random random;

    private Coder() {
    }

    public static String base64Encode(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static String base64Encode(String data) {
        assert (!Strings.isNullOrEmpty((String)data));
        try {
            return Base64.encodeBase64String((byte[])data.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] base64Decode(String data) {
        assert (!Strings.isNullOrEmpty((String)data));
        return Base64.decodeBase64((String)data);
    }

    public static String base64DecodeToStr(String data) {
        assert (!Strings.isNullOrEmpty((String)data));
        try {
            return new String(Base64.decodeBase64((String)data), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String md5Hex(String src) {
        return DigestUtils.md5Hex((String)src);
    }

    public static String md5Hex(String src, String prefix) {
        return prefix + DigestUtils.md5Hex((String)src);
    }

    public static String uuid() {
        return Coder.uuid("");
    }

    public static String uuid(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }

    public static String uuid2() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uniqueCode() {
        return Coder.md5Hex(Coder.uuid());
    }

    public static String randomNum(int length) {
        block3: {
            if (null == random) {
                try {
                    random = SecureRandom.getInstance("SHA1PRNG");
                    random.setSeed(System.nanoTime());
                }
                catch (NoSuchAlgorithmException ex) {
                    if (random != null) break block3;
                    random = new Random(System.nanoTime());
                }
            }
        }
        Double p = Math.pow(10.0, length);
        long min = p.longValue();
        long nextLong = random.nextLong();
        long value = (nextLong < 0L ? -nextLong : nextLong) % min;
        String fm = "%0" + length + "d";
        return String.format(fm, value);
    }
}

