/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.commons;

import com.dtyunxi.cube.utils.enums.IDoubleKeyListValueMapElement;
import com.dtyunxi.cube.utils.enums.IListValueMapElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MyMapUtils {
    public static <K, V extends IListValueMapElement<K>> Map<K, List<V>> buildListValueMap(List<V> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap map = new HashMap();
        for (IListValueMapElement v : list) {
            MyMapUtils.appendElement2ListMap(map, v.key(), v);
        }
        return map;
    }

    public static <K1, K2, V extends IDoubleKeyListValueMapElement<K1, K2>> Map<K1, Map<K2, List<V>>> buildDoubleListValueMap(List<V> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap map = new HashMap();
        for (IDoubleKeyListValueMapElement v : list) {
            MyMapUtils.appendDoubleLevelListMap(map, v.key1(), v.key2(), v);
        }
        return map;
    }

    public static <K, V> void appendElement2ListMap(Map<K, List<V>> map, K key, V entity) {
        List<Object> list = null;
        if (map.containsKey(key)) {
            list = map.get(key);
            if (list == null) {
                list = new LinkedList();
            }
        } else {
            list = new LinkedList();
            map.put(key, list);
        }
        list.add(entity);
    }

    public static <K1, K2, V> void appendDoubleLevelListMap(Map<K1, Map<K2, List<V>>> map, K1 key1, K2 key2, V entity) {
        if (map.containsKey(key1)) {
            Map<K2, List<V>> nameRecordMap = map.get(key1);
            if (nameRecordMap == null) {
                nameRecordMap = new HashMap<K2, List<V>>();
            }
            MyMapUtils.createOneLevelMap(key2, nameRecordMap, entity);
        } else {
            LinkedList<V> list = new LinkedList<V>();
            HashMap<K2, LinkedList<V>> nameRecordMap = new HashMap<K2, LinkedList<V>>();
            list.add(entity);
            nameRecordMap.put(key2, list);
            map.put(key1, nameRecordMap);
        }
    }

    public static <K1, K2, V> void appendDoubleLevelMap(Map<K1, Map<K2, V>> map, K1 key1, K2 key2, V entity) {
        if (map.containsKey(key1)) {
            Map<K2, V> nameRecordMap = map.get(key1);
            if (nameRecordMap == null) {
                nameRecordMap = new HashMap<K2, V>();
            }
            nameRecordMap.put(key2, entity);
        } else {
            HashMap<K2, V> nameRecordMap = new HashMap<K2, V>();
            nameRecordMap.put(key2, entity);
            map.put(key1, nameRecordMap);
        }
    }

    public static <K1, K2, V> List<V> getListElement(Map<K1, Map<K2, List<V>>> map, K1 key1, K2 key2) {
        Map<K2, List<V>> listMap;
        if (map.containsKey(key1) && (listMap = map.get(key1)) != null) {
            return listMap.get(key2);
        }
        return new ArrayList();
    }

    public static <K1, K2, V> V getEntityElement(Map<K1, Map<K2, V>> map, K1 key1, K2 key2) {
        Map<K2, V> entityMap;
        if (map.containsKey(key1) && (entityMap = map.get(key1)) != null) {
            return entityMap.get(key2);
        }
        return null;
    }

    public static <K, V> void createOneLevelMap(K key, Map<K, List<V>> map, V entity) {
        List<Object> list = null;
        if (map.containsKey(key)) {
            list = map.get(key);
            if (list == null) {
                list = new LinkedList();
            }
        } else {
            list = new LinkedList();
            map.put(key, list);
        }
        list.add(entity);
    }
}

