/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.RandomUtil;
import com.dtyunxi.cube.utils.codec.AESUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApplicationKeyUtil {
    public static String INSTANCE_ID = "instanceId";
    public static String TENANT_ID = "tenantId";
    public static String NONCESTR = "noncestr";

    public static String generate(String instanceId, String tenantId, String secretKey) {
        String result;
        if (StringUtils.isEmpty((CharSequence)instanceId)) {
            throw new RuntimeException("instanceId is empty");
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new RuntimeException("tenantId is empty");
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new RuntimeException("secretKey is empty");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(INSTANCE_ID, (Object)instanceId);
        jsonObject.put(TENANT_ID, (Object)tenantId);
        jsonObject.put(NONCESTR, (Object)RandomUtil.generateMixString(16));
        try {
            result = AESUtil.aesEncrypt(jsonObject.toJSONString(), secretKey);
        }
        catch (Exception e) {
            throw new RuntimeException("generate ApplicationKey error", e);
        }
        return result;
    }

    public static Map<String, String> decrypt(String applicationKey, String secretKey) {
        Map result;
        if (StringUtils.isEmpty((CharSequence)applicationKey)) {
            throw new RuntimeException("applicationKey is empty");
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new RuntimeException("secretKey is empty");
        }
        try {
            String decryptString = AESUtil.aesDecrypt(applicationKey, secretKey);
            result = (Map)JSONObject.parseObject((String)decryptString, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException("generate ApplicationKey error", e);
        }
        return result;
    }
}

