/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;

public class DateConverter
implements Converter {
    public Object convert(Class arg0, Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return source;
        }
        if (!(source instanceof String)) {
            throw new ConversionException("\u53ea\u652f\u6301\u5b57\u7b26\u4e32\u8f6c\u6362 !");
        }
        String str = (String)source;
        if (str.trim().equals("")) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        try {
            String value = str.trim();
            String sb = "";
            if (value.matches("^\\d{4}/\\d{1,2}$")) {
                sb = "yyyy/MM";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2}$")) {
                sb = "yyyy/MM/dd";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy/MM/dd HH:mm";
            } else if (value.matches("^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy/MM/dd HH:mm:ss";
            }
            if (value.matches("^\\d{4}-\\d{1,2}$")) {
                sb = "yyyy-MM";
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
                sb = "yyyy-MM-dd";
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy-MM-dd HH:mm";
            } else if (value.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
                sb = "yyyy-MM-dd HH:mm:ss";
            }
            return new SimpleDateFormat(sb).parse(value);
        }
        catch (Exception var5) {
            try {
                long date = Long.parseLong(str.trim());
                return date > 0L ? new Date(date) : null;
            }
            catch (Exception var4) {
                throw new IllegalArgumentException("Failed to convert from type java.lang.String to type java.util.Date");
            }
        }
    }
}

