/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.bean;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class CubeBeanUtils {
    private static Logger logger = LoggerFactory.getLogger(CubeBeanUtils.class);
    private static Map<Class<?>, Object> simpleBeanTypeMap = new HashMap<Class<?>, Object>(32){
        {
            this.put(BigDecimal.class, null);
            this.put(BigInteger.class, null);
            this.put(Boolean.class, null);
            this.put(Byte.class, null);
            this.put(Character.class, null);
            this.put(Double.class, null);
            this.put(Float.class, null);
            this.put(Integer.class, null);
            this.put(Long.class, null);
            this.put(Short.class, null);
            this.put(String.class, null);
            this.put(Class.class, null);
            this.put(java.util.Date.class, null);
            this.put(LocalDateTime.class, null);
            this.put(Calendar.class, null);
            this.put(File.class, null);
            this.put(Date.class, null);
            this.put(Time.class, null);
            this.put(Timestamp.class, null);
            this.put(URL.class, null);
            this.put(Currency.class, null);
            this.put(UUID.class, null);
        }
    };

    public static void copyProperties(Object target, Object source, String ... ignoreProperties) {
        CubeBeanUtils.copyProperties(target, source, false, ignoreProperties);
    }

    public static void copyProperties(Object target, Object source, boolean copyNull, String ... ignoreProperties) {
        if (target == null || source == null) {
            logger.info("---------copyProperties-------target or source is null");
            return;
        }
        if (simpleBeanTypeMap.containsKey(target.getClass()) || simpleBeanTypeMap.containsKey(source.getClass())) {
            return;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(target.getClass());
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                if (value != null) {
                    if (!simpleBeanTypeMap.containsKey(value.getClass())) {
                        if (value instanceof Collection) {
                            value = CubeBeanUtils.collectionCopy(targetPd, value, copyNull);
                        } else if (value instanceof Map) {
                            value = CubeBeanUtils.mapCopy(targetPd, value);
                        } else {
                            Object newObj = value;
                            try {
                                newObj = writeMethod.getParameterTypes()[0].newInstance();
                                CubeBeanUtils.copyProperties(newObj, value, copyNull, new String[0]);
                            }
                            catch (Exception e) {
                                logger.error("targetPd newInstance Exception:", (Throwable)e);
                            }
                            value = newObj;
                        }
                    }
                    writeMethod.invoke(target, value);
                    continue;
                }
                if (!copyNull) continue;
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                String errorMsg = "copyProperties Exception==>> sourceClassName:{}" + source.getClass() + ", targetClassName:{}" + target.getClass() + ", fieldName:" + sourcePd.getName() + ", sourceFieldClass:" + sourcePd.getPropertyType() + ", targetFieldClass:" + targetPd.getPropertyType();
                throw new RuntimeException(errorMsg);
            }
        }
    }

    private static Object mapCopy(PropertyDescriptor descriptor, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Map targetMap = value.getClass().getSimpleName().contains("Persistent") ? new HashMap() : (Map)value.getClass().newInstance();
        Map sourceMap = (Map)value;
        Set keySet = sourceMap.keySet();
        for (Object key : keySet) {
            Object sourceObj = sourceMap.get(key);
            if (key == null || sourceObj == null) continue;
            targetMap.put(key, sourceObj);
        }
        return targetMap;
    }

    private static Object collectionCopy(PropertyDescriptor descriptor, Object value, boolean copyNull) {
        if (value == null) {
            return null;
        }
        Collection targetCollection = null;
        try {
            Class<?> genericClazz = CubeBeanUtils.getGenericClazz(descriptor, value.getClass(), 0);
            Collection sourceCollection = (Collection)value;
            if (sourceCollection.isEmpty()) {
                return sourceCollection;
            }
            String simpleName = value.getClass().getSimpleName();
            if (simpleName.contains("Persistent")) {
                if (value instanceof Set) {
                    targetCollection = new HashSet();
                } else if (value instanceof List) {
                    targetCollection = new ArrayList();
                }
            } else {
                targetCollection = simpleName.contains("ArrayList") || simpleName.contains("SingletonList") ? new ArrayList() : (Collection)value.getClass().newInstance();
            }
            CubeBeanUtils.copyCollection(targetCollection, sourceCollection, genericClazz, copyNull);
        }
        catch (Exception e) {
            logger.error("collectionCopy Exception:", (Throwable)e);
        }
        return targetCollection;
    }

    private static Class<?> getGenericClazz(PropertyDescriptor descriptor, Class<?> clazz, int index) {
        Class genericClazz = clazz;
        Type fc = descriptor.getWriteMethod().getGenericParameterTypes()[0];
        if (fc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)fc;
            genericClazz = (Class)pt.getActualTypeArguments()[index];
        }
        return genericClazz;
    }

    public static void copyCollection(Collection target, Collection source, Class<?> targetClazz) {
        CubeBeanUtils.copyCollection(target, source, targetClazz, false);
    }

    public static void copyCollection(Collection target, Collection source, Class<?> targetClazz, boolean copyNull) {
        if (source == null || source.isEmpty()) {
            return;
        }
        for (Object sourceObj : source) {
            Object newObj;
            if (simpleBeanTypeMap.containsKey(sourceObj.getClass())) {
                target.add(sourceObj);
                continue;
            }
            try {
                newObj = targetClazz.newInstance();
            }
            catch (Exception e) {
                logger.error("copyCollection newInstance Exception:", (Throwable)e);
                target.add(sourceObj);
                continue;
            }
            CubeBeanUtils.copyProperties(newObj, sourceObj, copyNull, new String[0]);
            target.add(newObj);
        }
    }
}

