/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.bean;

import com.dtyunxi.cube.utils.bean.PATTEN;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static final String EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String MOBILE = "^((13[0-9])|(14[0-9])|(15[0-9])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}";
    public static final String USERNAME = "^([\\w\\.-]+)$";
    public static final String DIGITAL = "^(\\d+)$";

    private RegexUtils() {
    }

    public static String extract(String str, String patten, int i) {
        List<String> res = RegexUtils.extract(str, patten);
        if (!res.isEmpty() && i <= res.size()) {
            return res.get(i - 1);
        }
        return null;
    }

    public static boolean isMatches(String str, String patten) {
        Pattern p = Pattern.compile(patten);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isMatches(String str, PATTEN patten) {
        return RegexUtils.isMatches(str, patten.get());
    }

    public static List<String> extract(String str, String patten) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern p = Pattern.compile(patten, 8);
        Matcher m = p.matcher(str);
        while (m.find()) {
            res.add(m.group(1));
        }
        return res;
    }

    public static String replaceMatches(String org, String patten, String str) {
        Pattern p = Pattern.compile(patten, 8);
        Matcher ma = p.matcher(org);
        return ma.replaceAll(str);
    }

    public static boolean isExpire(Date nowDate, Date creatDate, Long expire) {
        return nowDate.getTime() > creatDate.getTime() + expire;
    }

    public static boolean isMobile(String mobile) {
        return RegexUtils.isMatches(mobile, MOBILE);
    }

    public static boolean isEmail(String email) {
        return RegexUtils.isMatches(email, EMAIL);
    }

    public static boolean isUsername(String username) {
        return RegexUtils.isMatches(username, USERNAME) && !RegexUtils.isMatches(username, DIGITAL);
    }
}

