/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

@Deprecated
public class HttpUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");

    public static String get(String url) throws IOException {
        return HttpUtil.get(url, null);
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("GET", url, null, headers);
    }

    public static String post(String url, String body, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("POST", url, body, headers);
    }

    public static String post(String url, String body) throws IOException {
        return HttpUtil.post(url, body, null);
    }

    public static String postForm(String url, Map<String, String> params) throws IOException {
        return HttpUtil.postForm(url, params, null);
    }

    public static String postForm(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        String body = "";
        if (params != null) {
            boolean first = true;
            for (String param : params.keySet()) {
                if (first) {
                    first = false;
                } else {
                    body = body + "&";
                }
                String value = params.get(param);
                body = body + URLEncoder.encode(param, "UTF-8") + "=";
                body = body + URLEncoder.encode(value, "UTF-8");
            }
        }
        return HttpUtil.post(url, body, headers);
    }

    public static String put(String url, String body, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("PUT", url, body, headers);
    }

    public static String put(String url, String body) throws IOException {
        return HttpUtil.put(url, body, null);
    }

    public static String delete(String url, Map<String, String> headers) throws IOException {
        return HttpUtil.fetch("DELETE", url, null, headers);
    }

    public static String delete(String url) throws IOException {
        return HttpUtil.delete(url, null);
    }

    public static String appendQueryParams(String url, Map<String, String> params) throws IOException {
        String fullUrl = url;
        if (params != null) {
            boolean first = fullUrl.indexOf(63) == -1;
            for (String param : params.keySet()) {
                if (first) {
                    fullUrl = fullUrl + '?';
                    first = false;
                } else {
                    fullUrl = fullUrl + '&';
                }
                String value = params.get(param);
                fullUrl = fullUrl + URLEncoder.encode(param, "UTF-8") + '=';
                fullUrl = fullUrl + URLEncoder.encode(value, "UTF-8");
            }
        }
        return fullUrl;
    }

    public static Map<String, String> getQueryParams(String url) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        int start = url.indexOf(63);
        while (start != -1) {
            int equals = url.indexOf(61, start);
            String param = "";
            param = equals != -1 ? url.substring(start + 1, equals) : url.substring(start + 1);
            String value = "";
            if (equals != -1) {
                start = url.indexOf(38, equals);
                value = start != -1 ? url.substring(equals + 1, start) : url.substring(equals + 1);
            }
            params.put(URLDecoder.decode(param, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
        }
        return params;
    }

    public static String removeQueryParams(String url) throws IOException {
        int q = url.indexOf(63);
        if (q != -1) {
            return url.substring(0, q);
        }
        return url;
    }

    public static String fetch(String method, String url, String body, Map<String, String> headers) throws IOException {
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        if (method != null) {
            conn.setRequestMethod(method);
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.addRequestProperty(key, headers.get(key));
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
            os.flush();
            os.close();
        }
        boolean isGzip = false;
        String charset = null;
        if (conn.getResponseCode() == 200) {
            String contentEncoding = conn.getHeaderField("Content-Encoding");
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                isGzip = true;
            }
            String contentType = conn.getHeaderField("Content-Type");
            charset = HttpUtil.getCharsetFromContentType(contentType);
        }
        InputStream is = conn.getInputStream();
        String response = HttpUtil.streamToString(is, charset, isGzip);
        is.close();
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            return HttpUtil.fetch(method, location, body, headers);
        }
        return response;
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            if ((charset = charset.replace("charset=", "")).length() == 0) {
                return null;
            }
            try {
                if ("gb2312".equalsIgnoreCase(charset) || "gbk".equalsIgnoreCase(charset)) {
                    charset = "gb18030";
                }
                if (Charset.isSupported(charset)) {
                    return charset;
                }
                if (Charset.isSupported(charset = charset.toUpperCase(Locale.ENGLISH))) {
                    return charset;
                }
            }
            catch (IllegalCharsetNameException e) {
                return null;
            }
        }
        return null;
    }

    public static String streamToString(InputStream is, String charset, boolean isGzip) throws IOException {
        if (charset == null || "".equals(charset.trim())) {
            charset = "utf-8";
        }
        BufferedReader reader = null;
        reader = isGzip ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(is), charset)) : new BufferedReader(new InputStreamReader(is, charset));
        String line = "";
        StringBuffer result = new StringBuffer();
        while (null != (line = reader.readLine())) {
            if ("".equals(line)) continue;
            result.append(line).append("\r\n");
        }
        return result.toString();
    }
}

