/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import com.dtyunxi.cube.utils.enums.DatePattern;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;

public final class DateUtil {
    public static final String YMD_DATA = "yyyy-MM-dd";
    public static final String YMD01_DATA = "yyyy/MM/dd";
    public static final String YMDHMS_DATA = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDSTRING_DATA = "yyyyMMddHHmmss";
    public static final String YMDGB_DATA = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String YMDTHMSGB_DATA = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2";
    public static final String YMD24H_DATA = "yyyy-MM-dd HH:mm:ss";
    public static final String[] DAYNAMES = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    public static final int ONE_DAY_MILLISECONDS = 86400000;
    public static final int ONE_HOUR_MILLISECONDS = 3600000;
    public static final int ONE_MINUTE_MILLISECONDS = 60000;
    public static final int ONE_SECOND_MILLISECONDS = 1000;
    public static final long ONE_YEAR_MILLISECONDS = 1471228928L;

    private DateUtil() {
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2);
    }

    public static int getDayOfMonth() {
        return Calendar.getInstance().get(5);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static String getDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        return DAYNAMES[dayOfWeek - 1];
    }

    public static String getDateWeek(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(date, "YYYY-MM-DD"));
        int dayOfWeek = calendar.get(7);
        return dayOfWeek + "";
    }

    public static String getYMD() {
        return DateUtil.getYMD("-");
    }

    public static String getYMD(String separator) {
        Calendar now = Calendar.getInstance();
        return now.get(1) + separator + (now.get(2) + 1) + separator + now.get(5);
    }

    public static String getYMD_CN() {
        Calendar now = Calendar.getInstance();
        return now.get(1) + "\u5e74" + (now.get(2) + 1) + "\u6708" + now.get(5) + "\u65e5";
    }

    public static String getDateFormat(Date date, String format) {
        String result = "";
        try {
            if (date != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                result = dateFormat.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getDateFormat(Calendar calendar, String format) {
        return DateUtil.getDateFormat(calendar.getTime(), format);
    }

    public static Date parseDate(String dateStr, String format) {
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        Date date = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            date = null;
        }
        return date;
    }

    public static Date getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayDiff(Date start, Date end) {
        Date d1 = DateUtil.getDayBegin(start);
        Date d2 = DateUtil.getDayBegin(end);
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }

    public static long getMiniteDiff(Date start, Date end) {
        return end.getTime() / 60000L - start.getTime() / 60000L;
    }

    public static String getTimeDiff(Date start, Date end) {
        int days = (int)((end.getTime() - start.getTime()) / 86400000L);
        int hours = (int)((end.getTime() - start.getTime()) / 3600000L % 24L);
        int minutes = (int)((end.getTime() - start.getTime()) / 60000L % 60L);
        String timeDiff = "";
        if (days > 0) {
            timeDiff = days + "\u5929";
        }
        timeDiff = timeDiff + hours + "\u5c0f\u65f6" + minutes + "\u5206";
        return timeDiff;
    }

    public static String getTimeDiffWithMilliseconds(Date start, Date end) {
        long dif = end.getTime() - start.getTime();
        int days = (int)(dif / 86400000L);
        int hours = (int)(dif / 3600000L % 24L);
        int minutes = (int)(dif / 60000L % 60L);
        int seconds = (int)(dif / 1000L % 60L);
        int difMilliseconds = (int)(dif % 1000L);
        StringBuilder timeDiff = new StringBuilder();
        if (days > 0) {
            timeDiff.append(days).append("\u5929");
        }
        if (hours > 0) {
            timeDiff.append(hours).append("\u5c0f\u65f6");
        }
        if (minutes > 0) {
            timeDiff.append(minutes).append("\u5206");
        }
        if (seconds > 0) {
            timeDiff.append(seconds).append("\u79d2");
        }
        if (difMilliseconds > 0) {
            timeDiff.append(difMilliseconds).append("\u6beb\u79d2");
        }
        return timeDiff.toString();
    }

    public static String getMonthFirstDay(Date date) {
        return DateUtil.getDateFormat(DateUtil.getMonthBegin(date), YMD_DATA);
    }

    public static String getMonthLastDay(Date date) {
        return DateUtil.getDateFormat(DateUtil.getMonthEnd(date), YMD_DATA);
    }

    public static Date getMonthBegin() {
        return DateUtil.getMonthBegin(new Date());
    }

    public static Date getMonthEnd() {
        return DateUtil.getMonthEnd(new Date());
    }

    public static Date getMonthBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return DateUtil.getDayBegin(calendar);
    }

    public static Date getMonthEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return DateUtil.getDayEnd(calendar);
    }

    public static Date getDayBegin() {
        return DateUtil.getDayBegin(Calendar.getInstance());
    }

    public static Date getDayEnd() {
        return DateUtil.getDayEnd(Calendar.getInstance());
    }

    public static Date getDayBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        return DateUtil.getDayBegin(calendar);
    }

    public static Date getDayBegin(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        return DateUtil.getDayEnd(calendar);
    }

    public static Date getDayEnd(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minutes);
        return calendar.getTime();
    }

    public static Date addHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar.getTime();
    }

    public static Date addMonths(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static int getAge(Date birthday) {
        if (birthday == null) {
            return 0;
        }
        long time = (new Date().getTime() - birthday.getTime()) / 1000L;
        if (time < 0L) {
            return 0;
        }
        return (int)(time / 31536000L);
    }

    public static Calendar getCalendar(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    public static Date getDate(long time) {
        Calendar calendar = DateUtil.getCalendar(time);
        return calendar.getTime();
    }

    public static String getDateToString(Date date) {
        if (date == null) {
            return "";
        }
        return new DateTime(date.getTime()).toString(DatePattern.DATETIME_PATTERN.getPattern());
    }

    public static String formatDate(DatePattern pattern, Date date) {
        if (pattern == null) {
            return "";
        }
        if (date == null) {
            return "";
        }
        return new DateTime(date.getTime()).toString(pattern.getPattern());
    }

    public static Date checkDateParam(String dateTime) throws ParseException {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(YMD01_DATA);
        if (StringUtils.isNotBlank((CharSequence)dateTime)) {
            date = sdf.parse(dateTime);
        }
        return date;
    }

    public static Date getStartOfDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static Date getEndOfDay(Date date) {
        return DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)date, (int)5), (int)-1);
    }
}

