/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static final String FILE_EXTENSION_SEPARATOR = ".";

    public static String read(String filePath) {
        return FileUtil.read(filePath, "utf-8");
    }

    public static String read(String filePath, String encoding) {
        StringBuilder content = new StringBuilder();
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean write(String filePath, String content, String encoding, boolean append) {
        OutputStreamWriter fileWriter = null;
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fileWriter = new FileWriter(filePath, append);
            fileWriter.write(content);
            fileWriter.write("\r\n");
            fileWriter.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static boolean write(String filePath, String content, String encoding) {
        return FileUtil.write(filePath, content, encoding, false);
    }

    public static boolean write(String filePath, String content) {
        return FileUtil.write(filePath, content, "utf-8", false);
    }

    public static boolean append(String filePath, String content, String encoding) {
        return FileUtil.write(filePath, content, encoding, true);
    }

    public static boolean append(String filePath, String content) {
        return FileUtil.write(filePath, content, "utf-8", true);
    }

    public static boolean write(String filePath, InputStream stream) {
        FileOutputStream o = null;
        try {
            o = new FileOutputStream(filePath);
            byte[] data = new byte[1024];
            int length = -1;
            while ((length = stream.read(data)) != -1) {
                ((OutputStream)o).write(data, 0, length);
            }
            o.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("FileNotFoundException occurred. ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred. ", e);
        }
        finally {
            if (o != null) {
                try {
                    ((OutputStream)o).close();
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException occurred. ", e);
                }
            }
        }
    }

    public static List<String> readFilesToList(String filePath) {
        File file = new File(filePath);
        ArrayList<String> fileContent = new ArrayList<String>();
        if (file != null && file.isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    fileContent.add(line);
                }
                reader.close();
                ArrayList<String> arrayList = fileContent;
                return arrayList;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException occurred. ", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("IOException occurred. ", e);
                    }
                }
            }
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return filePath;
        }
        int extenPosi = filePath.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int filePosi = filePath.lastIndexOf(File.separator);
        if (filePosi == -1) {
            return extenPosi == -1 ? filePath : filePath.substring(0, extenPosi);
        }
        if (extenPosi == -1) {
            return filePath.substring(filePosi + 1);
        }
        return filePosi < extenPosi ? filePath.substring(filePosi + 1, extenPosi) : filePath.substring(filePosi + 1);
    }

    public static String getFileName(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        if (filePosi == -1) {
            return filePath;
        }
        return filePath.substring(filePosi + 1);
    }

    public static String getFolderName(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        if (filePosi == -1) {
            return "";
        }
        return filePath.substring(0, filePosi);
    }

    public static String getFileExtension(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return filePath;
        }
        int extenPosi = filePath.lastIndexOf(FILE_EXTENSION_SEPARATOR);
        int filePosi = filePath.lastIndexOf(File.separator);
        if (extenPosi == -1) {
            return "";
        }
        if (filePosi >= extenPosi) {
            return "";
        }
        return filePath.substring(extenPosi + 1);
    }

    public static boolean makeFolder(String filePath) {
        String folderName = FileUtil.getFolderName(filePath);
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        File folder = new File(folderName);
        return folder.exists() && folder.isDirectory() || folder.mkdirs();
    }

    public static boolean isFileExist(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static boolean isFolderExist(String directoryPath) {
        if (directoryPath == null || "".equals(directoryPath)) {
            return false;
        }
        File dire = new File(directoryPath);
        return dire.exists() && dire.isDirectory();
    }

    public static boolean deleteFile(String path) {
        if (path == null || "".equals(path)) {
            return true;
        }
        File file = new File(path);
        if (file.exists()) {
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    if (f.isFile()) {
                        f.delete();
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    FileUtil.deleteFile(f.getAbsolutePath());
                }
                return file.delete();
            }
            return false;
        }
        return true;
    }

    public static long getFileSize(String path) {
        if (path == null || "".equals(path)) {
            return -1L;
        }
        File file = new File(path);
        return file.exists() && file.isFile() ? file.length() : -1L;
    }

    public static void findFiles(String baseDirName, String targetFileName, List fileList) {
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDirName + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + "\\" + filelist[i]);
                if (!readfile.isDirectory()) {
                    tempName = readfile.getName();
                    if (!FileUtil.wildcardMatch(targetFileName, tempName)) continue;
                    fileList.add(readfile.getAbsoluteFile());
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                FileUtil.findFiles(baseDirName + "\\" + filelist[i], targetFileName, fileList);
            }
        }
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (FileUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static boolean copy(String oldFile, String newFile) {
        return false;
    }

    public static boolean copy(String fromFile, String toFile, String fromEncoding, String toEncoding) {
        String fileContent = FileUtil.read(fromFile, fromEncoding);
        FileUtil.write(toFile, fileContent, toEncoding);
        return true;
    }
}

