/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.starter.cache.CubeCacheProperties;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import java.time.Duration;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.JedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.LettuceConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;

@EnableConfigurationProperties(value={CubeCacheProperties.class})
@PropertySource(value={"classpath:config/redis.properties"})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@Import(value={LettuceConnectionConfiguration.class, JedisConnectionConfiguration.class})
public class CustomRedisAutoConfiguration {
    private final CacheRegistryVo cacheRegistryVo;

    public CustomRedisAutoConfiguration(CacheRegistryVo cacheRegistryVo) {
        this.cacheRegistryVo = cacheRegistryVo;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public RedisProperties redisProperties() {
        RedisProperties redisProperties = new RedisProperties();
        switch (this.cacheRegistryVo.getWorkModelEnum()) {
            case SINGLE: {
                if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getHost()) && StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getPort())) {
                    redisProperties.setHost(this.cacheRegistryVo.getHost());
                    redisProperties.setPort(Integer.parseInt(this.cacheRegistryVo.getPort()));
                    break;
                }
                if (ArrayUtil.isNotEmpty((Object[])this.cacheRegistryVo.getAddresses())) {
                    String url = this.cacheRegistryVo.getAddresses()[0];
                    if (ReUtil.isMatch((String)"^.+:\\d+$", (CharSequence)url)) {
                        String[] strArray = url.split(":");
                        redisProperties.setHost(strArray[0]);
                        redisProperties.setPort(Integer.parseInt(strArray[1]));
                        break;
                    }
                    redisProperties.setHost(url);
                    redisProperties.setPort(6379);
                    break;
                }
                throw new IllegalArgumentException("url\u6216\u8005host+port\u5fc5\u987b\u6709\u4e00\u9879\u914d\u7f6e\uff01");
            }
            case CLUSTER: {
                RedisProperties.Cluster cluster = new RedisProperties.Cluster();
                cluster.setNodes(Arrays.asList(this.cacheRegistryVo.getAddresses()));
                redisProperties.setCluster(cluster);
                break;
            }
            case SENTINEL: {
                RedisProperties.Sentinel sentinel = new RedisProperties.Sentinel();
                sentinel.setNodes(Arrays.asList(this.cacheRegistryVo.getAddresses()));
                sentinel.setPassword(this.cacheRegistryVo.getAppSecret());
                redisProperties.setSentinel(sentinel);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getAppId())) {
            redisProperties.setUsername(this.cacheRegistryVo.getAppId());
        }
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getAppSecret())) {
            redisProperties.setPassword(this.cacheRegistryVo.getAppSecret());
        }
        redisProperties.setDatabase(this.cacheRegistryVo.getDbIndex());
        redisProperties.setSsl(this.cacheRegistryVo.isSsl());
        RedisProperties.Pool pool = new RedisProperties.Pool();
        pool.setMaxActive(this.cacheRegistryVo.getMaxTotal());
        pool.setMaxIdle(this.cacheRegistryVo.getMaxIdle());
        pool.setMinIdle(1);
        pool.setMaxWait(Duration.ofMillis(this.cacheRegistryVo.getMaxWaitMillis()));
        if (StrUtil.isNotBlank((CharSequence)this.cacheRegistryVo.getRedisClientType()) && this.cacheRegistryVo.getRedisClientType().equalsIgnoreCase("JEDIS")) {
            redisProperties.setClientType(RedisProperties.ClientType.JEDIS);
            redisProperties.getJedis().setPool(pool);
        } else {
            redisProperties.setClientType(RedisProperties.ClientType.LETTUCE);
            redisProperties.getLettuce().setPool(pool);
        }
        return redisProperties;
    }
}

