/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.api;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.cache.provider.AliyunMemCache;
import com.dtyunxi.huieryun.cache.provider.MemCached;
import com.dtyunxi.huieryun.cache.provider.RedisCache;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory {
    private static Logger logger = LoggerFactory.getLogger(CacheFactory.class);

    public static ICacheService createCache(String group, CacheRegistryVo cacheRegistryVo) {
        AbstractCacheService cacheService = null;
        if (cacheRegistryVo != null && cacheRegistryVo.getType() != null) {
            switch (cacheRegistryVo.getType().toUpperCase()) {
                case "REDIS": 
                case "ALIYUN_REDIS": {
                    cacheService = new RedisCache();
                    break;
                }
                case "MEMCACHED": {
                    cacheService = new MemCached();
                    break;
                }
                case "ALIYUN_MEMCACHE": {
                    cacheService = new AliyunMemCache();
                    break;
                }
            }
        }
        if (cacheService == null) {
            logger.error("\u672a\u6307\u5b9aCacheService\u7c7b\u578b");
            throw new IllegalArgumentException("\u672a\u6307\u5b9aCacheService\u7c7b\u578b");
        }
        cacheService.init(group, cacheRegistryVo);
        return cacheService;
    }
}

