/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.provider;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;

public class MemCached
extends AbstractCacheService {
    private static final Logger logger = LoggerFactory.getLogger(MemCached.class);

    @Override
    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
    }

    private MemcachedClient getMemcachedClient() {
        MemcachedClient client = null;
        try {
            client = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build(), AddrUtil.getAddresses((String)this.cacheRegistryVo.getAddresses()[0]));
        }
        catch (IOException e) {
            logger.error("\u521b\u5efaMemcached\u7f13\u5b58\u5b9e\u4f8b\u51fa\u9519: {}", (Object)this.cacheRegistryVo, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCache(String group, String key, Object value, int seconds) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture add = client.set(this.combineKey(group, key), seconds, value);
            boolean bl = (Boolean)add.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key {}, value {}", new Object[]{key, value, e});
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, Class<T> clz) {
        MemcachedClient client = null;
        try {
            Object obj;
            client = this.getMemcachedClient();
            Object object = obj = client.get(this.combineKey(group, key));
            return (T)object;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key {}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(client);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delCache(String group, String key) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture delete = client.delete(this.combineKey(group, key));
            boolean bl = (Boolean)delete.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7f13\u5b58\u51fa\u9519: key {}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, Object value, int seconds) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture add = client.add(this.combineKey(key), seconds, value);
            boolean bl = (Boolean)add.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7f13\u5b58\u51fa\u9519: key {}, value {}", new Object[]{key, value, e});
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    @Override
    public Long incr(String key) {
        return this.incr(key, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key, long initValue) {
        MemcachedClient client = null;
        Long v = null;
        try {
            client = this.getMemcachedClient();
            key = this.combineKey(key);
            v = client.incr(key, 1, initValue);
            if (v >= 1000000L) {
                client.delete(key);
            } else if (v <= 0L) {
                client.delete(key);
                v = Math.abs(v);
            } else if (v == initValue) {
                v = Thread.currentThread().getId();
            }
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58\u81ea\u589e\u5931\u8d25: key {}, initValue {}", new Object[]{key, initValue, e});
        }
        finally {
            this.shutdown(client);
        }
        return v;
    }

    public void shutdown(MemcachedClient client) {
        if (null != client) {
            client.shutdown();
        }
    }

    @Override
    public boolean setPersistCache(String group, String key, Object value) {
        throw new RuntimeException("MemCached\u6301\u4e45\u5316\u5bf9\u8c61\u51fa\u9519");
    }

    @Override
    public <T> void lpush(String group, String key, List<T> value, int seconds) {
        throw new RuntimeException("MemCached\u961f\u5217 \u987a\u5e8f\u5b58\u50a8\u51fa\u9519");
    }

    @Override
    public <T> void rpush(String group, String key, List<T> value, int seconds) {
        throw new RuntimeException("MemCached\u961f\u5217\u53cd\u5411\u5b58\u50a8\u51fa\u9519");
    }

    @Override
    public <T> List<T> getList(String group, String key, Integer from, Integer to, Class<T> clz) {
        throw new RuntimeException("MemCached\u96c6\u5408\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public <T> void hset(String group, String key, String field, T value, int seconds) {
        throw new RuntimeException("MemCached\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public <T> T hget(String group, String key, String field, Class<T> clz) {
        throw new RuntimeException("MemCached\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public <T> List<T> hget(String group, String key, String field, TypeReference<List<T>> typeReference) {
        throw new RuntimeException("MemCached\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public <K, V> Map<K, V> hgetMap(String group, String key, String field, TypeReference<Map<K, V>> typeReference) {
        throw new RuntimeException("MemCached\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public boolean hdel(String group, String key, String ... field) {
        throw new RuntimeException("MemCached\u5220\u9664map\u5143\u7d20\u6570\u636e\u51fa\u9519");
    }

    @Override
    public boolean expire(String group, String key, int seconds) {
        throw new RuntimeException("MemCached\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u51fa\u9519");
    }

    @Override
    public Set<String> getKeys(String group, String pattern) {
        throw new RuntimeException("MemCached\u83b7\u53d6\u6240\u6709key\u65f6\u51fa\u9519");
    }

    @Override
    public Set<String> getKeysByScan(String group, String pattern) {
        throw new RuntimeException("MemCached\u83b7\u53d6\u6240\u6709key\u65f6\u51fa\u9519");
    }

    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers) {
        throw new RuntimeException("MemCached\u8c03\u7528zadd\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Set<String> zrange(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u8c03\u7528zrange\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Set<String> zrevrange(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u8c03\u7528zrevrange\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zrem(String group, String key, List<String> members) {
        throw new RuntimeException("MemCached\u8c03\u7528zrem\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zcard(String group, String key) {
        throw new RuntimeException("MemCached\u8c03\u7528zcard\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zscore(String group, String key, String members) {
        throw new RuntimeException("MemCached\u8c03\u7528zscore\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zcount(String group, String key, Long min, Long max) {
        throw new RuntimeException("MemCached\u8c03\u7528zcount\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zcount(String group, String key, String min, String max) {
        throw new RuntimeException("MemCached\u8c03\u7528zcount\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        throw new RuntimeException("MemCached\u8c03\u7528zscan\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public ScanResult<Tuple> zscan(String group, String key, String cursor) {
        throw new RuntimeException("MemCached\u8c03\u7528zscan\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers, int seconds) {
        throw new RuntimeException("MemCached\u8c03\u7528zadd\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Map<Long, String> zrangeWithScores(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u8c03\u7528zrangeWithScores\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Map<Long, String> zrevrangeWithScores(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u8c03\u7528zrevrangeWithScores\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Long incrBy(String key, long count) {
        return null;
    }

    @Override
    public Long incrBy(String key, long count, long initValue) {
        return null;
    }

    @Override
    public Long setnx(String group, String key, String value) {
        return null;
    }

    @Override
    public Transaction multi() {
        return null;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String watch(String ... key) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0watch");
    }

    @Override
    public void unwatch() {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0unwatch");
    }
}

