/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.api;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheService
implements ICacheService {
    public static final int CONNECTION_TIMEOUT = 3000;
    private static final Logger logger = LoggerFactory.getLogger(AbstractCacheService.class);
    protected CacheRegistryVo cacheRegistryVo;
    protected String group;

    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        this.cacheRegistryVo = cacheRegistryVo;
        this.group = group;
    }

    @Override
    public boolean setCache(String key, Object value) {
        return this.setCache(this.group, key, value, 3000);
    }

    @Override
    public boolean setCache(String group, String key, Object value) {
        return this.setCache(group, key, value, 3000);
    }

    @Override
    public boolean setCache(String key, Object value, int seconds) {
        return this.setCache(this.group, key, value, seconds);
    }

    @Override
    public boolean setPersistCache(String key, Object value) {
        return this.setPersistCache(this.group, key, value);
    }

    @Override
    public <T> T getCache(String key, Class<T> clz) {
        return this.getCache(this.group, key, clz);
    }

    @Override
    public <T> T getCache(String key, TypeReference<T> clz) {
        return this.getCache(this.group, key, clz);
    }

    @Override
    public boolean delCache(String key) {
        return this.delCache(this.group, key);
    }

    @Override
    public Set<String> delCacheByPattern(String pattern) {
        return this.delCacheByPattern(this.group, pattern);
    }

    @Override
    public boolean add(String key, Object value) {
        return this.add(key, value, 3000);
    }

    @Override
    public <T> void lpush(String key, List<T> value) {
        this.lpush(this.group, key, value, 0);
    }

    @Override
    public <T> void lpush(String key, List<T> value, int seconds) {
        this.lpush(this.group, key, value, seconds);
    }

    @Override
    public <T> void lpush(String group, String key, List<T> value) {
        this.lpush(group, key, value, 0);
    }

    @Override
    public <T> void rpush(String key, List<T> value) {
        this.rpush(this.group, key, value, 0);
    }

    @Override
    public <T> void rpush(String key, List<T> value, int seconds) {
        this.rpush(this.group, key, value, seconds);
    }

    @Override
    public <T> void rpush(String group, String key, List<T> value) {
        this.rpush(group, key, value, 0);
    }

    @Override
    public <T> List<T> mget(String[] keys, Class<T> clz) {
        return this.mget(this.group, keys, clz);
    }

    @Override
    public <T> List<T> mget(String[] keys, TypeReference<T> clz) {
        return this.mget(this.group, keys, clz);
    }

    @Override
    public <T> List<T> getList(String key, Class<T> clz) {
        return this.getList(this.group, key, 0, -1, clz);
    }

    @Override
    public <T> List<T> getList(String group, String key, Class<T> clz) {
        return this.getList(group, key, 0, -1, clz);
    }

    @Override
    public <T> List<T> getList(String key, Integer from, Integer to, Class<T> clz) {
        return this.getList(this.group, key, from, to, clz);
    }

    @Override
    public <T> void hset(String key, String field, T value) {
        this.hset(this.group, key, field, value, 0);
    }

    @Override
    public <T> void hset(String group, String key, String field, T value) {
        this.hset(group, key, field, value, 0);
    }

    @Override
    public <T> void hset(String key, String field, T value, int seconds) {
        this.hset(this.group, key, field, value, seconds);
    }

    @Override
    public <T> T hget(String key, String field, Class<T> clz) {
        return this.hget(this.group, key, field, clz);
    }

    @Override
    public <T> List<T> hget(String key, String field, TypeReference<List<T>> typeReference) {
        return this.hget(this.group, key, field, typeReference);
    }

    @Override
    public <K, V> Map<K, V> hgetMap(String key, String field, TypeReference<Map<K, V>> typeReference) {
        return this.hgetMap(this.group, key, field, typeReference);
    }

    @Override
    public boolean hdel(String key, String[] field) {
        return this.hdel(this.group, key, field);
    }

    @Override
    public Long hincrBy(String key, String field, int count) {
        return this.hincrBy(this.group, key, field, count);
    }

    @Override
    public Long hincrBy(String key, String field, Long count) {
        return this.hincrBy(this.group, key, field, count);
    }

    @Override
    public Long hincrByWithException(String key, String field, Long value) {
        return this.hincrByWithException(this.group, key, field, value);
    }

    @Override
    public Double hincrByWithException(String key, String field, Double value) {
        return this.hincrByWithException(this.group, key, field, value);
    }

    @Override
    public Long zadd(String key, Long score, String member) {
        HashMap<String, Long> scoreMembers = new HashMap<String, Long>();
        scoreMembers.put(member, score);
        return this.zadd(this.group, key, scoreMembers);
    }

    @Override
    public Long zadd(String key, Map<String, Long> scoreMembers) {
        return this.zadd(this.group, key, scoreMembers);
    }

    @Override
    public Long zadd(String group, String key, Long score, String member) {
        HashMap<String, Long> scoreMembers = new HashMap<String, Long>();
        scoreMembers.put(member, score);
        return this.zadd(group, key, scoreMembers);
    }

    @Override
    public Long zadd(String key, Long score, String member, int seconds) {
        HashMap<String, Long> scoreMembers = new HashMap<String, Long>();
        scoreMembers.put(member, score);
        return this.zadd(this.group, key, scoreMembers, seconds);
    }

    @Override
    public Long zadd(String key, Map<String, Long> scoreMembers, int seconds) {
        return this.zadd(this.group, key, scoreMembers, seconds);
    }

    @Override
    public Long zadd(String group, String key, Long score, String member, int seconds) {
        HashMap<String, Long> scoreMembers = new HashMap<String, Long>();
        scoreMembers.put(member, score);
        return this.zadd(group, key, scoreMembers, seconds);
    }

    @Override
    public Set<String> zrange(String key) {
        return this.zrange(this.group, key, 0L, -1L);
    }

    @Override
    public Set<String> zrange(String group, String key) {
        return this.zrange(group, key, 0L, -1L);
    }

    @Override
    public Set<String> zrange(String key, Long start, Long end) {
        return this.zrange(this.group, key, start, end);
    }

    @Override
    public Map<Long, String> zrangeWithScores(String key) {
        return this.zrangeWithScores(this.group, key, 0L, -1L);
    }

    @Override
    public Map<Long, String> zrangeWithScores(String group, String key) {
        return this.zrangeWithScores(group, key, 0L, -1L);
    }

    @Override
    public Map<Long, String> zrangeWithScores(String key, Long start, Long end) {
        return this.zrangeWithScores(this.group, key, start, end);
    }

    @Override
    public Set<String> zrevrange(String key) {
        return this.zrevrange(this.group, key, 0L, -1L);
    }

    @Override
    public Set<String> zrevrange(String group, String key) {
        return this.zrevrange(group, key, 0L, -1L);
    }

    @Override
    public Set<String> zrevrange(String key, Long start, Long end) {
        return this.zrevrange(this.group, key, start, end);
    }

    @Override
    public Map<Long, String> zrevrangeWithScores(String key) {
        return this.zrevrangeWithScores(this.group, key, 0L, -1L);
    }

    @Override
    public Map<Long, String> zrevrangeWithScores(String group, String key) {
        return this.zrevrangeWithScores(group, key, 0L, -1L);
    }

    @Override
    public Map<Long, String> zrevrangeWithScores(String key, Long start, Long end) {
        return this.zrevrangeWithScores(this.group, key, start, end);
    }

    @Override
    public Long zrem(String key, String member) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(member);
        return this.zrem(this.group, key, list);
    }

    @Override
    public Long zrem(String key, List<String> members) {
        return this.zrem(this.group, key, members);
    }

    @Override
    public Long zrem(String group, String key, String member) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(member);
        return this.zrem(group, key, list);
    }

    @Override
    public Long zcard(String key) {
        return this.zcard(this.group, key);
    }

    @Override
    public Long zscore(String key, String members) {
        return this.zscore(this.group, key, members);
    }

    @Override
    public Long zcount(String key, Long min, Long max) {
        return this.zcount(this.group, key, min, max);
    }

    @Override
    public Long zcount(String key, String min, String max) {
        return this.zcount(this.group, key, min, max);
    }

    @Override
    public Set<String> getKeys() {
        return this.getKeys(this.group, "*");
    }

    @Override
    public Set<String> getKeys(String pattern) {
        return this.getKeys(this.group, pattern);
    }

    @Override
    public boolean expire(String key, int seconds) {
        return this.expire(this.group, key, seconds);
    }

    @Override
    public Long setnx(String key, String value) {
        return this.setnx(this.group, key, value);
    }

    @Override
    public long getToLiveTime(String key) {
        return this.getToLiveTime(this.group, key);
    }

    public String combineKey(String key) {
        return this.group + ":" + key;
    }

    public String combineKey(String group, String key) {
        if (StringUtils.isNotBlank((CharSequence)group)) {
            return group + ":" + key;
        }
        return key;
    }

    public String[] combineKeyValues(String group, String[] keysvalues) {
        String[] templ = new String[keysvalues.length];
        for (int keyIdx = 0; keyIdx < templ.length / 2; ++keyIdx) {
            templ[keyIdx * 2] = this.combineKey(group, keysvalues[keyIdx * 2]);
            templ[keyIdx * 2 + 1] = keysvalues[keyIdx * 2 + 1];
        }
        return templ;
    }

    public String[] combineKeys(String group, String[] keys) {
        String[] templ = new String[keys.length];
        for (int keyIdx = 0; keyIdx < templ.length; ++keyIdx) {
            templ[keyIdx] = this.combineKey(group, keys[keyIdx]);
        }
        return templ;
    }

    public Map<String, String> combineKeys(String group, Map<String, String> dataMap) {
        HashMap<String, String> templ = new HashMap<String, String>();
        for (Map.Entry<String, String> m : dataMap.entrySet()) {
            templ.put(this.combineKey(group, m.getKey()), m.getValue());
        }
        return templ;
    }

    public String[] combineKeyValues(String group, Map<String, String> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            String[] templ = new String[dataMap.size() * 2];
            int index = 0;
            for (Map.Entry<String, String> m : dataMap.entrySet()) {
                templ[index * 2] = this.combineKey(group, m.getKey());
                templ[index * 2 + 1] = m.getValue();
                ++index;
            }
            return templ;
        }
        return null;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean mset(Map<String, String> dataMap) {
        return this.mset(this.group, dataMap);
    }

    @Override
    public void subscribe(String channel, IRedisSubProcessor<String> processor) {
        this.subscribe(this.group, channel, processor);
    }

    @Override
    public void publish(String channel, String message) {
        this.publish(this.group, channel, message);
    }

    @Override
    public boolean pfadd(String key, String[] elements) {
        return this.pfadd(this.group, key, elements);
    }

    @Override
    public long pfcount(String key) {
        return this.pfcount(this.group, key);
    }

    @Override
    public long pfcount(String[] keys) {
        return this.pfcount(this.group, keys);
    }

    @Override
    public boolean pfmerge(String destKey, String[] sourceKeys) {
        return this.pfmerge(this.group, destKey, sourceKeys);
    }
}

