/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.api;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.cache.api.IRedisCacheService;
import com.dtyunxi.huieryun.cache.provider.AliyunMemCache;
import com.dtyunxi.huieryun.cache.provider.MemCached;
import com.dtyunxi.huieryun.cache.provider.RedisCache;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactory {
    private static Logger logger = LoggerFactory.getLogger(CacheFactory.class);

    public static ICacheService createCache(String group, CacheRegistryVo cacheRegistryVo) {
        AbstractCacheService cacheService = null;
        if (cacheRegistryVo != null && cacheRegistryVo.getType() != null) {
            switch (cacheRegistryVo.getType().toUpperCase()) {
                case "REDIS": 
                case "ALIYUN_REDIS": {
                    cacheService = new RedisCache();
                    break;
                }
                case "MEMCACHED": {
                    cacheService = new MemCached();
                    break;
                }
                case "ALIYUN_MEMCACHE": {
                    cacheService = new AliyunMemCache();
                    break;
                }
            }
        }
        if (cacheService == null) {
            logger.error("\u672a\u6307\u5b9aCacheService\u7c7b\u578b");
            throw new IllegalArgumentException("\u672a\u6307\u5b9aCacheService\u7c7b\u578b");
        }
        cacheService.init(group, cacheRegistryVo);
        return cacheService;
    }

    public static IRedisCacheService createRedisCache(String group, CacheRegistryVo cacheRegistryVo) {
        RedisCache redisCacheService = null;
        if (cacheRegistryVo != null) {
            redisCacheService = new RedisCache();
        }
        if (redisCacheService == null) {
            logger.error("\u8bf7\u914d\u7f6eredis\u8fde\u63a5\u4fe1\u606f");
            throw new IllegalArgumentException("\u8bf7\u914d\u7f6eredis\u8fde\u63a5\u4fe1\u606f");
        }
        redisCacheService.init(group, cacheRegistryVo);
        return redisCacheService;
    }
}

