/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.api;

import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;

public interface ICacheService {
    public static final String TYPE_REDIS = "REDIS";
    public static final String TYPE_MEMCACHED = "MEMCACHED";
    public static final String TYPE_ALIYUN_REDIS = "ALIYUN_REDIS";
    public static final String TYPE_ALIYUN_MEMCACHE = "ALIYUN_MEMCACHE";

    public boolean setCache(String var1, Object var2);

    public boolean setCache(String var1, Object var2, int var3);

    public boolean setCache(String var1, String var2, Object var3);

    public boolean setCache(String var1, String var2, Object var3, int var4);

    public boolean setPersistCache(String var1, Object var2);

    public boolean setPersistCache(String var1, String var2, Object var3);

    public <T> T getCache(String var1, Class<T> var2);

    public <T> T getCache(String var1, String var2, Class<T> var3);

    public <T> T getCache(String var1, TypeReference<T> var2);

    public <T> T getCache(String var1, String var2, TypeReference<T> var3);

    public boolean delCache(String var1);

    public boolean delCache(String var1, String var2);

    public Set<String> delCacheByPattern(String var1);

    public Set<String> delCacheByPattern(String var1, String var2);

    public boolean add(String var1, Object var2);

    public boolean add(String var1, Object var2, int var3);

    default public Long incr(String key) {
        return this.incr(key, 0L);
    }

    default public Long incrWithException(String key) {
        return this.incrWithException(key, 0L);
    }

    default public Long incr(String key, long seconds) {
        return this.incrBy(key, 1L, seconds);
    }

    default public Long incrWithException(String key, long seconds) {
        return this.incrByWithException(key, 1L, seconds);
    }

    default public Long incrBy(String key, long increment) {
        return this.incrBy(key, increment, 0L);
    }

    default public Long incrByWithException(String key, long increment) {
        return this.incrByWithException(key, increment, 0L);
    }

    default public Long incrBy(String key, long increment, long seconds) {
        try {
            return this.incrByWithException(key, increment, seconds);
        }
        catch (RuntimeException runtimeException) {
            return 0L;
        }
    }

    public Long incrByWithException(String var1, long var2, long var4);

    default public Double incrBy(String key, double increment) {
        return this.incrBy(key, increment, 0L);
    }

    default public Double incrByWithException(String key, double increment) {
        return this.incrByWithException(key, increment, 0L);
    }

    default public Double incrBy(String key, double increment, long seconds) {
        try {
            return this.incrByWithException(key, increment, 0L);
        }
        catch (RuntimeException runtimeException) {
            return Double.NaN;
        }
    }

    public Double incrByWithException(String var1, double var2, long var4);

    public <T> void lpush(String var1, List<T> var2);

    public <T> void lpush(String var1, List<T> var2, int var3);

    public <T> void lpush(String var1, String var2, List<T> var3);

    public <T> void lpush(String var1, String var2, List<T> var3, int var4);

    public <T> void rpush(String var1, List<T> var2);

    public <T> void rpush(String var1, List<T> var2, int var3);

    public <T> void rpush(String var1, String var2, List<T> var3);

    public <T> void rpush(String var1, String var2, List<T> var3, int var4);

    public <T> List<T> mget(String[] var1, Class<T> var2);

    public <T> List<T> mget(String var1, String[] var2, Class<T> var3);

    public <T> List<T> mget(String[] var1, TypeReference<T> var2);

    public <T> List<T> mget(String var1, String[] var2, TypeReference<T> var3);

    public <T> List<T> getList(String var1, Class<T> var2);

    public <T> List<T> getList(String var1, String var2, Class<T> var3);

    public <T> List<T> getList(String var1, Integer var2, Integer var3, Class<T> var4);

    public <T> List<T> getList(String var1, String var2, Integer var3, Integer var4, Class<T> var5);

    public <T> void hset(String var1, String var2, T var3);

    public <T> void hset(String var1, String var2, T var3, int var4);

    public <T> void hset(String var1, String var2, String var3, T var4);

    public <T> void hset(String var1, String var2, String var3, T var4, int var5);

    public <T> T hget(String var1, String var2, Class<T> var3);

    public <T> T hget(String var1, String var2, String var3, Class<T> var4);

    public <T> List<T> hget(String var1, String var2, TypeReference<List<T>> var3);

    public <T> List<T> hget(String var1, String var2, String var3, TypeReference<List<T>> var4);

    public <K, V> Map<K, V> hgetMap(String var1, String var2, TypeReference<Map<K, V>> var3);

    public <K, V> Map<K, V> hgetMap(String var1, String var2, String var3, TypeReference<Map<K, V>> var4);

    public boolean hdel(String var1, String[] var2);

    public boolean hdel(String var1, String var2, String[] var3);

    default public Long hincrBy(String key, String field, int value) {
        try {
            return this.hincrByWithException(key, field, Long.valueOf(value));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    default public Long hincrByWithException(String key, String field, int value) {
        return this.hincrByWithException(key, field, Long.valueOf(value));
    }

    default public Long hincrBy(String group, String key, String field, int value) {
        try {
            return this.hincrByWithException(group, key, field, Long.valueOf(value));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    default public Long hincrByWithException(String group, String key, String field, int value) {
        return this.hincrByWithException(group, key, field, Long.valueOf(value));
    }

    default public Long hincrBy(String key, String field, Long value) {
        try {
            return this.hincrByWithException(key, field, value);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public Long hincrByWithException(String var1, String var2, Long var3);

    default public Long hincrBy(String group, String key, String field, Long value) {
        try {
            return this.hincrByWithException(group, key, field, value);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public Long hincrByWithException(String var1, String var2, String var3, Long var4);

    default public Double hincrBy(String key, String field, Double value) {
        try {
            return this.hincrByWithException(key, field, value);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public Double hincrByWithException(String var1, String var2, Double var3);

    default public Double hincrBy(String group, String key, String field, Double value) {
        try {
            return this.hincrByWithException(group, key, field, value);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public Double hincrByWithException(String var1, String var2, String var3, Double var4);

    public boolean expire(String var1, int var2);

    public boolean expire(String var1, String var2, int var3);

    public Set<String> getKeys();

    public Set<String> getKeys(String var1);

    public Set<String> getKeys(String var1, String var2);

    public Long zadd(String var1, Long var2, String var3);

    public Long zadd(String var1, Long var2, String var3, int var4);

    public Long zadd(String var1, Map<String, Long> var2);

    public Long zadd(String var1, Map<String, Long> var2, int var3);

    public Long zadd(String var1, String var2, Long var3, String var4);

    public Long zadd(String var1, String var2, Long var3, String var4, int var5);

    public Long zadd(String var1, String var2, Map<String, Long> var3);

    public Long zadd(String var1, String var2, Map<String, Long> var3, int var4);

    public Set<String> zrange(String var1);

    public Set<String> zrange(String var1, String var2);

    public Set<String> zrange(String var1, Long var2, Long var3);

    public Set<String> zrange(String var1, String var2, Long var3, Long var4);

    public Map<Long, String> zrangeWithScores(String var1);

    public Map<Long, String> zrangeWithScores(String var1, String var2);

    public Map<Long, String> zrangeWithScores(String var1, Long var2, Long var3);

    public Map<Long, String> zrangeWithScores(String var1, String var2, Long var3, Long var4);

    public Set<String> zrevrange(String var1);

    public Set<String> zrevrange(String var1, String var2);

    public Set<String> zrevrange(String var1, Long var2, Long var3);

    public Set<String> zrevrange(String var1, String var2, Long var3, Long var4);

    public Map<Long, String> zrevrangeWithScores(String var1);

    public Map<Long, String> zrevrangeWithScores(String var1, String var2);

    public Map<Long, String> zrevrangeWithScores(String var1, Long var2, Long var3);

    public Map<Long, String> zrevrangeWithScores(String var1, String var2, Long var3, Long var4);

    public Long zrem(String var1, String var2);

    public Long zrem(String var1, List<String> var2);

    public Long zrem(String var1, String var2, String var3);

    public Long zrem(String var1, String var2, List<String> var3);

    public Long zcard(String var1);

    public Long zcard(String var1, String var2);

    public Long zscore(String var1, String var2);

    public Long zscore(String var1, String var2, String var3);

    public Long zcount(String var1, Long var2, Long var3);

    public Long zcount(String var1, String var2, String var3);

    public Long zcount(String var1, String var2, Long var3, Long var4);

    public Long zcount(String var1, String var2, String var3, String var4);

    public ScanResult<Tuple> zscan(String var1, String var2);

    public ScanResult<Tuple> zscan(String var1, String var2, String var3);

    public Long setnx(String var1, String var2);

    public Long setnx(String var1, String var2, String var3);

    public Transaction multi();

    public void shutdown();

    public String watch(String ... var1);

    public void unwatch();

    public Map<String, String> hgetAll(String var1);

    public Map<String, String> hgetAll(String var1, String var2);

    public ScanResult<Map.Entry<String, String>> hscan(String var1, String var2);

    public ScanResult<Map.Entry<String, String>> hscan(String var1, String var2, String var3);

    public List<String> hmget(String var1, String[] var2);

    public List<String> hmget(String var1, String var2, String[] var3);

    public <T> Map<String, T> hmget(String var1, String[] var2, Class<T> var3);

    public <T> Map<String, T> hmget(String var1, String var2, String[] var3, Class<T> var4);

    public <T> Map<String, List<T>> hmget(String var1, String[] var2, TypeReference<List<T>> var3);

    public <T> Map<String, List<T>> hmget(String var1, String var2, String[] var3, TypeReference<List<T>> var4);

    public Set<String> hkeys(String var1);

    public Set<String> hkeys(String var1, String var2);

    public long getToLiveTime(String var1);

    public long getToLiveTime(String var1, String var2);

    public boolean mset(String var1, Map<String, String> var2);

    public boolean mset(Map<String, String> var1);

    public boolean hmset(String var1, Map<String, String> var2);

    public boolean hmset(String var1, String var2, Map<String, String> var3);

    public void subscribe(String var1, IRedisSubProcessor<String> var2);

    public void subscribe(String var1, String var2, IRedisSubProcessor<String> var3);

    public void subscribeKeyExpiredEvent(IRedisSubProcessor<String> var1);

    public void publish(String var1, String var2, String var3);

    public void publish(String var1, String var2);

    public boolean pfadd(String var1, String[] var2);

    public boolean pfadd(String var1, String var2, String[] var3);

    public long pfcount(String var1);

    public long pfcount(String var1, String var2);

    public long pfcount(String[] var1);

    public long pfcount(String var1, String[] var2);

    public boolean pfmerge(String var1, String[] var2);

    public boolean pfmerge(String var1, String var2, String[] var3);
}

