/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.provider;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;

public class MemCached
extends AbstractCacheService {
    private static final Logger logger = LoggerFactory.getLogger(MemCached.class);

    @Override
    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        super.init(group, cacheRegistryVo);
    }

    private MemcachedClient getMemcachedClient() {
        MemcachedClient client = null;
        try {
            client = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).build(), AddrUtil.getAddresses((String)this.cacheRegistryVo.getAddresses()[0]));
        }
        catch (IOException e) {
            logger.error("\u521b\u5efaMemcached\u7f13\u5b58\u5b9e\u4f8b\u51fa\u9519: {}", (Object)this.cacheRegistryVo, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCache(String group, String key, Object value, int seconds) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture add = client.set(this.combineKey(group, key), seconds, value);
            boolean bl = (Boolean)add.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key {}, value {}", new Object[]{key, value, e});
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, Class<T> clz) {
        MemcachedClient client = null;
        try {
            Object obj;
            client = this.getMemcachedClient();
            Object object = obj = client.get(this.combineKey(group, key));
            return (T)object;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key {}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(client);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, TypeReference<T> clz) {
        MemcachedClient client = null;
        try {
            Object obj;
            client = this.getMemcachedClient();
            Object object = obj = client.get(this.combineKey(group, key));
            return (T)object;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key {}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(client);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delCache(String group, String key) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture delete = client.delete(this.combineKey(group, key));
            boolean bl = (Boolean)delete.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7f13\u5b58\u51fa\u9519: key {}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, Object value, int seconds) {
        MemcachedClient client = null;
        try {
            client = this.getMemcachedClient();
            OperationFuture add = client.add(this.combineKey(key), seconds, value);
            boolean bl = (Boolean)add.get();
            return bl;
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7f13\u5b58\u51fa\u9519: key {}, value {}", new Object[]{key, value, e});
        }
        finally {
            this.shutdown(client);
        }
        return false;
    }

    @Override
    public Long incrByWithException(String key, long initValue) {
        MemcachedClient client = null;
        Long v = null;
        try {
            client = this.getMemcachedClient();
            key = this.combineKey(key);
            v = client.incr(key, 1, initValue);
            if (v >= 1000000L) {
                client.delete(key);
            } else if (v <= 0L) {
                client.delete(key);
                v = Math.abs(v);
            } else if (v == initValue) {
                v = Thread.currentThread().getId();
            }
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        finally {
            this.shutdown(client);
        }
        return v;
    }

    @Override
    public Long incrByWithException(String key, long increment, long seconds) {
        return null;
    }

    @Override
    public Double incrByWithException(String key, double increment, long seconds) {
        return null;
    }

    public void shutdown(MemcachedClient client) {
        if (null != client) {
            client.shutdown();
        }
    }

    @Override
    public boolean setPersistCache(String group, String key, Object value) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> void lpush(String group, String key, List<T> value, int seconds) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> void rpush(String group, String key, List<T> value, int seconds) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> List<T> getList(String group, String key, Integer from, Integer to, Class<T> clz) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> void hset(String group, String key, String field, T value, int seconds) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> T hget(String group, String key, String field, Class<T> clz) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> List<T> hget(String group, String key, String field, TypeReference<List<T>> typeReference) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <K, V> Map<K, V> hgetMap(String group, String key, String field, TypeReference<Map<K, V>> typeReference) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean hdel(String group, String key, String[] field) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long hincrBy(String key, String field, int count) {
        throw new RuntimeException("MemCached hincrBy \u51fa\u9519");
    }

    @Override
    public Long hincrBy(String group, String key, String field, int count) {
        throw new RuntimeException("MemCached hincrBy \u51fa\u9519");
    }

    @Override
    public Long hincrBy(String key, String field, Long count) {
        throw new RuntimeException("MemCached hincrBy \u51fa\u9519");
    }

    @Override
    public Long hincrBy(String group, String key, String field, Long count) {
        throw new RuntimeException("MemCached hincrBy \u51fa\u9519");
    }

    @Override
    public boolean expire(String group, String key, int seconds) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Set<String> getKeys(String group, String pattern) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Set<String> zrange(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Set<String> zrevrange(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zrem(String group, String key, List<String> members) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zcard(String group, String key) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zscore(String group, String key, String members) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zcount(String group, String key, Long min, Long max) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zcount(String group, String key, String min, String max) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public ScanResult<Tuple> zscan(String group, String key, String cursor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers, int seconds) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Map<Long, String> zrangeWithScores(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Map<Long, String> zrevrangeWithScores(String group, String key, Long start, Long end) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long incrBy(String key, long count, long initValue) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long setnx(String group, String key, String value) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Transaction multi() {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public void shutdown() {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public String watch(String ... key) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0watch");
    }

    @Override
    public void unwatch() {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0unwatch");
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Map<String, String> hgetAll(String group, String key) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String group, String key, String cursor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public List<String> hmget(String key, String[] fields) {
        return this.hmget(this.getGroup(), key, fields);
    }

    @Override
    public List<String> hmget(String group, String key, String[] fields) {
        throw new RuntimeException("MemCached\u8c03\u7528hmget\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public <T> Map<String, T> hmget(String key, String[] fields, Class<T> clazz) {
        return this.hmget(this.getGroup(), key, fields, clazz);
    }

    @Override
    public <T> Map<String, T> hmget(String group, String key, String[] fields, Class<T> clazz) {
        throw new RuntimeException("MemCached\u8c03\u7528hmget\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public <T> Map<String, List<T>> hmget(String key, String[] fields, TypeReference<List<T>> typeReference) {
        return this.hmget(this.getGroup(), key, fields, typeReference);
    }

    @Override
    public <T> Map<String, List<T>> hmget(String group, String key, String[] fields, TypeReference<List<T>> typeReference) {
        throw new RuntimeException("MemCached\u8c03\u7528hmget\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Set<String> hkeys(String key) {
        throw new RuntimeException("MemCached\u8c03\u7528hkeys\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public Set<String> hkeys(String group, String key) {
        throw new RuntimeException("MemCached\u8c03\u7528hkeys\u65b9\u6cd5\u65f6\u51fa\u9519");
    }

    @Override
    public long getToLiveTime(String group, String key) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean mset(String group, Map<String, String> dataMap) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean hmset(String key, Map<String, String> dataMap) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean hmset(String group, String key, Map<String, String> dataMap) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public void subscribe(String group, String channel, IRedisSubProcessor<String> processor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public void publish(String group, String channel, String message) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean pfadd(String group, String key, String[] elements) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public long pfcount(String group, String key) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public long pfcount(String group, String[] keys) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public boolean pfmerge(String group, String destKey, String[] sourceKeys) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Set<String> delCacheByPattern(String group, String pattern) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public void subscribeKeyExpiredEvent(IRedisSubProcessor<String> processor) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Long hincrByWithException(String group, String key, String field, Long value) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public Double hincrByWithException(String group, String key, String field, Double value) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> List<T> mget(String group, String[] keys, Class<T> clz) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public <T> List<T> mget(String group, String[] keys, TypeReference<T> clz) {
        throw new RuntimeException("MemCached\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }
}

