/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.cache.provider;

import com.dtyunxi.huieryun.cache.api.AbstractCacheService;
import com.dtyunxi.huieryun.cache.api.IRedisCacheService;
import com.dtyunxi.huieryun.cache.api.IRedisSubProcessor;
import com.dtyunxi.huieryun.cache.api.constants.WorkModel;
import com.dtyunxi.huieryun.cache.redis.conver.ListenerConver;
import com.dtyunxi.huieryun.cache.vo.CacheRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.util.Hashing;
import redis.clients.jedis.util.Sharded;

public class RedisCache
extends AbstractCacheService
implements IRedisCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static ThreadLocal<Jedis> threadLocal = new ThreadLocal();
    private static ThreadLocal<ShardedJedis> shardedThreadLocal = new ThreadLocal();
    private JedisPool jedisPool;
    private ShardedJedisPool shardedJedisPool;
    private JedisCluster jedisCluster;
    private int dbIndex;
    public static final String COLON_NAME = ":";

    @Override
    public void init(String group, CacheRegistryVo cacheRegistryVo) {
        if (logger.isDebugEnabled()) {
            logger.debug("group:{}, redis \u914d\u7f6e:{}", (Object)group, (Object)JacksonUtil.toJson((Object)((Object)cacheRegistryVo)));
        }
        super.init(group, cacheRegistryVo);
        this.checkAddress(cacheRegistryVo.getAddresses());
        this.dbIndex = cacheRegistryVo.getDbIndex();
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        this.setConfig((GenericObjectPoolConfig)poolConfig);
        if (WorkModel.SINGLE.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            String address = cacheRegistryVo.getAddresses()[0];
            String host = address.split(COLON_NAME)[0];
            String port = address.split(COLON_NAME)[1];
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, Integer.parseInt(port), 3000, StringUtils.isEmpty((CharSequence)cacheRegistryVo.getAppSecret()) ? null : cacheRegistryVo.getAppSecret(), this.dbIndex, cacheRegistryVo.isSsl());
        } else if (WorkModel.CLUSTER.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            this.jedisCluster = new JedisCluster(this.getHostAndPortSet(cacheRegistryVo), 3000, 3000, 1, StringUtils.isEmpty((CharSequence)cacheRegistryVo.getAppSecret()) ? null : cacheRegistryVo.getAppSecret(), (GenericObjectPoolConfig)poolConfig);
        } else if (WorkModel.SHARDING.getName().equalsIgnoreCase(cacheRegistryVo.getWorkModel())) {
            this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, this.getShardInfoList(cacheRegistryVo), Hashing.MURMUR_HASH, Sharded.DEFAULT_KEY_TAG_PATTERN);
        } else {
            throw new BusinessRuntimeException("\u521d\u59cb\u5316RedisCache\u65f6\u627e\u4e0d\u5230\u6307\u5b9a\u8fd0\u884c\u6a21\u5f0f\uff0cworkModel:" + cacheRegistryVo.getWorkModel());
        }
    }

    private void checkAddress(String[] addresses) {
        if (addresses == null) {
            throw new BusinessRuntimeException("\u8fde\u63a5RedisCache\u65f6\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Set<HostAndPort> getHostAndPortSet(CacheRegistryVo cacheRegistryVo) {
        HashSet<HostAndPort> hostAndPortSet = new HashSet<HostAndPort>();
        if (cacheRegistryVo.getAddresses() != null) {
            String[] addrs;
            for (String addr : addrs = cacheRegistryVo.getAddresses()) {
                HostAndPort hostAndPort = new HostAndPort(this.getHost(addr), this.getPort(addr));
                hostAndPortSet.add(hostAndPort);
            }
        } else {
            HostAndPort hostAndPort = new HostAndPort(cacheRegistryVo.getHost(), Integer.parseInt(cacheRegistryVo.getPort()));
            hostAndPortSet.add(hostAndPort);
        }
        return hostAndPortSet;
    }

    private List<JedisShardInfo> getShardInfoList(CacheRegistryVo cacheRegistryVo) {
        ArrayList<JedisShardInfo> shardsList = new ArrayList<JedisShardInfo>();
        if (cacheRegistryVo.getAddresses() != null) {
            String[] addrs;
            for (String addr : addrs = cacheRegistryVo.getAddresses()) {
                this.addShardInfo(this.getHost(addr), this.getPort(addr), cacheRegistryVo.getAppSecret(), shardsList);
            }
        } else {
            this.addShardInfo(cacheRegistryVo.getHost(), Integer.parseInt(cacheRegistryVo.getPort()), cacheRegistryVo.getAppSecret(), shardsList);
        }
        return shardsList;
    }

    private void addShardInfo(String host, Integer port, String appSecret, List<JedisShardInfo> shardsList) {
        StringBuilder uriHost = new StringBuilder("redis://").append(host).append(COLON_NAME).append(port);
        if (this.dbIndex > 0) {
            uriHost.append("/").append(this.dbIndex);
        }
        JedisShardInfo jedisShardInfo = new JedisShardInfo(uriHost.toString());
        if (StringUtils.isNotEmpty((CharSequence)appSecret)) {
            jedisShardInfo.setPassword(appSecret);
        }
        jedisShardInfo.setConnectionTimeout(3000);
        jedisShardInfo.setSoTimeout(3000);
        shardsList.add(jedisShardInfo);
    }

    private String getHost(String val) {
        return val.substring(0, val.indexOf(COLON_NAME));
    }

    private int getPort(String val) {
        return Integer.parseInt(val.substring(val.indexOf(COLON_NAME) + 1));
    }

    private void setConfig(GenericObjectPoolConfig config) {
        config.setMaxIdle(this.cacheRegistryVo.getMaxIdle());
        config.setMaxTotal(this.cacheRegistryVo.getMaxTotal());
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        config.setMaxWaitMillis((long)this.cacheRegistryVo.getMaxWaitMillis());
    }

    public final Jedis getJedis() {
        if (this.jedisPool == null) {
            return null;
        }
        return this.jedisPool.getResource();
    }

    public final ShardedJedis getShardedJedis() {
        if (this.shardedJedisPool == null) {
            return null;
        }
        return this.shardedJedisPool.getResource();
    }

    public final JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCache(String group, String key, Object value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String result = "";
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.setex(combineKey, seconds, jsonValue);
            } else if (shardedJedis != null) {
                result = shardedJedis.setex(combineKey, seconds, jsonValue);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.setex(combineKey, seconds, jsonValue);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("after setCache,key={},seconds={},value={},flag={}", new Object[]{combineKey, seconds, jsonValue, flag});
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPersistCache(String group, String key, Object value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String result = "";
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.expire(combineKey, 1);
                jds.persist(combineKey);
                result = jds.set(combineKey, jsonValue);
            } else if (shardedJedis != null) {
                shardedJedis.expire(combineKey, 1);
                shardedJedis.persist(combineKey);
                result = shardedJedis.set(combineKey, jsonValue);
            } else if (this.jedisCluster != null) {
                this.jedisCluster.expire(combineKey, 1);
                this.jedisCluster.persist(combineKey);
                result = this.jedisCluster.set(combineKey, jsonValue);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
            logger.debug("\u8bbe\u7f6e\u6301\u4e45\u5316\u7f13\u5b58: key={}", (Object)key);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("after setPersistCache,key={},value={},flag={}", new Object[]{combineKey, jsonValue, flag});
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Object value = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.get(combineKey);
            } else if (shardedJedis != null) {
                json = shardedJedis.get(combineKey);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.get(combineKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                value = JacksonUtil.readValue((String)json, clz);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCache(String group, String key, TypeReference<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Object value = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.get(combineKey);
            } else if (shardedJedis != null) {
                json = shardedJedis.get(combineKey);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.get(combineKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                value = JacksonUtil.readValue((String)json, clz);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delCache(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        Long del = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                del = jds.del(combineKey);
            } else if (shardedJedis != null) {
                del = shardedJedis.del(combineKey);
            } else if (this.jedisCluster != null) {
                del = this.jedisCluster.del(combineKey);
            }
            if (del > 0L) {
                flag = true;
            }
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> delCacheByPattern(String group, String pattern) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set<String> keys = null;
        String combineKey = this.combineKey(group, pattern);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                keys = jds.keys(combineKey);
                if (keys != null && !keys.isEmpty()) {
                    jds.del(keys.toArray(new String[0]));
                }
            } else if (shardedJedis != null) {
                keys = this.getKeys(combineKey, shardedJedis);
                if (keys != null && !keys.isEmpty()) {
                    for (String key : keys) {
                        shardedJedis.decr(key);
                    }
                }
            } else if (this.jedisCluster != null && (keys = this.getKeys(combineKey)) != null && !keys.isEmpty()) {
                this.jedisCluster.del(keys.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7f13\u5b58\u51fa\u9519,group={}", (Object)group, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, Object value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String combineKey = this.combineKey(key);
        String jsonValue = JacksonUtil.toJson((Object)value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            SetParams setParams = new SetParams().nx().ex(seconds);
            if (jds != null) {
                String responCode = jds.set(combineKey, jsonValue, setParams);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
            if (shardedJedis != null) {
                String responCode = shardedJedis.set(combineKey, jsonValue, setParams);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
            if (this.jedisCluster != null) {
                String responCode = this.jedisCluster.set(combineKey, jsonValue, setParams);
                boolean bl = responCode != null && responCode.equalsIgnoreCase("OK");
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7f13\u5b58\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public Long incr(String key, long seconds) {
        try {
            return this.incrWithException(key, seconds);
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            return 0L;
        }
    }

    @Override
    public Long incrWithException(String key, long seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long incr = 0L;
        String combineKey = this.combineKey(key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                incr = jds.incr(combineKey);
                this.expire((int)seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                incr = shardedJedis.incr(combineKey);
                this.expire((int)seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                incr = this.jedisCluster.incr(combineKey);
                this.expire((int)seconds, this.jedisCluster, combineKey);
            }
            Long l = incr;
            return l;
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    @Override
    public Long incrByWithException(String key, long increment, long seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long incr = 0L;
        String combineKey = this.combineKey(key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                incr = jds.incrBy(combineKey, increment);
                this.expire((int)seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                incr = shardedJedis.incrBy(combineKey, increment);
                this.expire((int)seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                incr = this.jedisCluster.incrBy(combineKey, increment);
                this.expire((int)seconds, this.jedisCluster, combineKey);
            }
            Long l = incr;
            return l;
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    @Override
    public Double incrByWithException(String key, double increment, long seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Double incr = Double.NaN;
        String combineKey = this.combineKey(key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                incr = jds.incrByFloat(combineKey, increment);
                this.expire((int)seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                incr = shardedJedis.incrByFloat(combineKey, increment);
                this.expire((int)seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                incr = this.jedisCluster.incrByFloat(combineKey, increment);
                this.expire((int)seconds, this.jedisCluster, combineKey);
            }
            Double d = incr;
            return d;
        }
        catch (Exception e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            throw new RuntimeException("incr\u7f13\u5b58\u51fa\u9519: key=" + key, e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    @Override
    public Long incrBy(String key, long increment, long seconds) {
        try {
            return this.incrByWithException(key, increment, seconds);
        }
        catch (RuntimeException e) {
            logger.error("incr\u7f13\u5b58\u51fa\u9519: key={}", (Object)key, (Object)e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void lpush(String group, String key, List<T> value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (value != null && !value.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    jds.del(combineKey);
                    String[] obj = this.getList(value);
                    jds.lpush(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    shardedJedis.del(combineKey);
                    String[] obj = this.getList(value);
                    shardedJedis.lpush(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    this.jedisCluster.del(combineKey);
                    String[] obj = this.getList(value);
                    this.jedisCluster.lpush(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217 \u987a\u5e8f\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void rpush(String group, String key, List<T> value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (value != null && !value.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    jds.del(combineKey);
                    String[] obj = this.getList(value);
                    jds.rpush(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    shardedJedis.del(combineKey);
                    String[] obj = this.getList(value);
                    shardedJedis.rpush(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    this.jedisCluster.del(combineKey);
                    String[] obj = this.getList(value);
                    this.jedisCluster.rpush(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217\u53cd\u5411\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
    }

    @Override
    public <T> List<T> mget(String group, String[] keys, Class<T> clz) {
        List<String> values = this.mget(group, keys);
        if (null == values || values.isEmpty()) {
            return null;
        }
        ArrayList<Object> objs = new ArrayList<Object>(values.size());
        for (String value : values) {
            if (value == null) continue;
            objs.add(JacksonUtil.readValue((String)value, clz));
        }
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> mget(String group, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String[] combineKeys = this.combineKeys(group, keys);
        List values = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                values = jds.mget(combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    values = this.jedisCluster.mget(combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("pfcount\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return values;
    }

    @Override
    public <T> List<T> mget(String group, String[] keys, TypeReference<T> clz) {
        List<String> values = this.mget(group, keys);
        if (null == values || values.isEmpty()) {
            return null;
        }
        ArrayList<Object> objs = new ArrayList<Object>(values.size());
        for (String value : values) {
            if (value == null) continue;
            objs.add(JacksonUtil.readValue((String)value, clz));
        }
        return objs;
    }

    private <T> String[] getList(List<T> value) {
        String[] obj = new String[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            obj[i] = JacksonUtil.toJson(value.get(i));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getList(String group, String key, Integer from, Integer to, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        ArrayList<Object> tlist = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            List list = null;
            if (jds != null) {
                list = jds.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.lrange(combineKey, (long)from.intValue(), (long)to.intValue());
            }
            if (clz.equals(String.class)) {
                List list2 = list;
                return list2;
            }
            if (!CollectionUtils.isEmpty((Collection)list)) {
                tlist = new ArrayList<Object>();
                for (String str : list) {
                    Object t = JacksonUtil.readValue((String)str, clz);
                    tlist.add(t);
                }
            }
            ArrayList<Object> arrayList = tlist;
            return arrayList;
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    public void shutdown(Jedis jds, ShardedJedis shardedJedis) {
        if (null != jds) {
            jds.close();
        }
        if (null != shardedJedis) {
            shardedJedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void hset(String group, String key, String field, T value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson(value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.hset(combineKey, field, jsonValue);
                this.expire(seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                shardedJedis.hset(combineKey, field, jsonValue);
                this.expire(seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                this.jedisCluster.hset(combineKey, field, jsonValue);
                this.expire(seconds, this.jedisCluster, combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}, value={}", new Object[]{combineKey, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hget(String group, String key, String field, Class<T> clz) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            Object object = StringUtils.isNotEmpty((CharSequence)json) ? JacksonUtil.readValue((String)json, clz) : null;
            return (T)object;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> hget(String group, String key, String field, TypeReference<List<T>> typeReference) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            List list = StringUtils.isNotEmpty((CharSequence)json) ? (List)JacksonUtil.readValue((String)json, typeReference) : null;
            return list;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Map<K, V> hgetMap(String group, String key, String field, TypeReference<Map<K, V>> typeReference) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String json = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                json = jds.hget(combineKey, field);
            } else if (shardedJedis != null) {
                json = shardedJedis.hget(combineKey, field);
            } else if (this.jedisCluster != null) {
                json = this.jedisCluster.hget(combineKey, field);
            }
            Map map = StringUtils.isNotEmpty((CharSequence)json) ? (Map)JacksonUtil.readValue((String)json, typeReference) : null;
            return map;
        }
        catch (Exception e) {
            logger.error("\u53d6\u51famap\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hdel(String group, String key, String[] field) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hdel(combineKey, field);
            } else if (shardedJedis != null) {
                result = shardedJedis.hdel(combineKey, field);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hdel(combineKey, field);
            }
            boolean bl = result > 0L;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664map\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return false;
    }

    @Override
    public Long hincrBy(String group, String key, String field, Long count) {
        try {
            return this.hincrByWithException(group, key, field, count);
        }
        catch (Exception e) {
            logger.error("map\u5143\u7d20\u6570\u636e\u51fa\u9519: key={}", (Object)key, (Object)e);
            return 0L;
        }
    }

    @Override
    public Long hincrByWithException(String group, String key, String field, Long value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hincrBy(combineKey, field, value.longValue());
            } else if (shardedJedis != null) {
                result = shardedJedis.hincrBy(combineKey, field, value.longValue());
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hincrBy(combineKey, field, value.longValue());
            }
            Long l = result;
            return l;
        }
        catch (Exception e) {
            logger.error("\u4e3a\u54c8\u5e0c\u8868 group={}\u548ckey={}\u4e2d\u7684\u57df field={}\u7684\u503c\u52a0\u4e0a\u589e\u91cf increment={}", new Object[]{group, field, key, value, e});
            throw new BusinessRuntimeException("\u4e3a\u54c8\u5e0c\u8868 group= " + group + ", key= " + key + "\u4e2d\u7684\u57df field= " + field + "\u7684\u503c\u52a0\u4e0a\u589e\u91cf increment=" + value, (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    @Override
    public Double hincrByWithException(String group, String key, String field, Double value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Double result = Double.NaN;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hincrByFloat(combineKey, field, value.doubleValue());
            } else if (shardedJedis != null) {
                result = shardedJedis.hincrByFloat(combineKey, field, value.doubleValue());
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hincrByFloat(combineKey.getBytes(StandardCharsets.UTF_8), field.getBytes(StandardCharsets.UTF_8), value.doubleValue());
            }
            Double d = result;
            return d;
        }
        catch (Exception e) {
            logger.error("\u4e3a\u54c8\u5e0c\u8868 group={}\u548ckey={}\u4e2d\u7684\u57df field={}\u7684\u503c\u52a0\u4e0a\u589e\u91cf increment={}", new Object[]{group, field, key, value, e});
            throw new BusinessRuntimeException("\u4e3a\u54c8\u5e0c\u8868 group= " + group + ", key= " + key + "\u4e2d\u7684\u57df field= " + field + "\u7684\u503c\u52a0\u4e0a\u589e\u91cf increment=" + value, (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(String group, String key, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.expire(combineKey, seconds);
            } else if (shardedJedis != null) {
                result = shardedJedis.expire(combineKey, seconds);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.expire(combineKey, seconds);
            }
            boolean bl = result > 0L;
            return bl;
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return false;
    }

    private void expire(int seconds, Jedis jds, String combineKey) {
        if (seconds > 0) {
            jds.expire(combineKey, seconds);
        }
    }

    protected void expire(int seconds, ShardedJedis shardedJedis, String combineKey) {
        if (seconds > 0) {
            shardedJedis.expire(combineKey, seconds);
        }
    }

    protected void expire(int seconds, JedisCluster jedisCluster, String combineKey) {
        if (seconds > 0) {
            jedisCluster.expire(combineKey, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys(String group, String pattern) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, pattern);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.keys(combineKey);
                return set;
            }
            if (shardedJedis != null) {
                Set<String> set = this.getKeys(combineKey, shardedJedis);
                return set;
            }
            if (this.jedisCluster != null) {
                Set<String> set = this.getKeys(combineKey);
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u7684\u6240\u6709key\u65f6\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers) {
        Map<String, Double> map;
        String combineKey;
        ShardedJedis shardedJedis;
        Jedis jds;
        block8: {
            block7: {
                jds = null;
                shardedJedis = null;
                combineKey = this.combineKey(group, key);
                map = this.getMap(scoreMembers);
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds == null) break block7;
                Long l = jds.zadd(combineKey, map);
                this.shutdown(jds, shardedJedis);
                return l;
            }
            if (shardedJedis == null) break block8;
            Long l = shardedJedis.zadd(combineKey, map);
            this.shutdown(jds, shardedJedis);
            return l;
        }
        try {
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zadd(combineKey, map);
                this.shutdown(jds, shardedJedis);
                return l;
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("\u5c06\u4e00\u4e2a\u6216\u591a\u4e2amember\u5143\u7d20\u53ca\u5176score\u503c\u52a0\u5165\u5230\u6709\u5e8f\u96c6key\u5f53\u4e2d\u65f6\u51fa\u9519: key:{},scoreMembers:{}", new Object[]{combineKey, scoreMembers, e});
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String group, String key, Map<String, Long> scoreMembers, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Map<String, Double> map = this.getMap(scoreMembers);
            if (jds != null) {
                jds.expire(combineKey, seconds);
                Long l = jds.zadd(combineKey, map);
                return l;
            }
            if (shardedJedis != null) {
                shardedJedis.expire(combineKey, seconds);
                Long l = shardedJedis.zadd(combineKey, map);
                return l;
            }
            if (this.jedisCluster != null) {
                this.jedisCluster.expire(combineKey, seconds);
                Long l = this.jedisCluster.zadd(combineKey, map);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u5c06\u4e00\u4e2a\u6216\u591a\u4e2amember\u5143\u7d20\u53ca\u5176score\u503c\u52a0\u5165\u5230\u6709\u5e8f\u96c6key\u5f53\u4e2d\u65f6\u51fa\u9519: key:{},scoreMembers:{}", new Object[]{combineKey, scoreMembers, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrange(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (shardedJedis != null) {
                Set set = shardedJedis.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (this.jedisCluster != null) {
                Set set = this.jedisCluster.zrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u6b63\u5e8f\u5206\u9875\u65f6\u51fa\u9519: key:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrange(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Set set = jds.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (shardedJedis != null) {
                Set set = shardedJedis.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
            if (this.jedisCluster != null) {
                Set set = this.jedisCluster.zrevrange(combineKey, start.longValue(), end.longValue());
                return set;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u53cd\u5e8f\u5206\u9875\u65f6\u51fa\u9519: key:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String group, String key, List<String> members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zrem(combineKey, members.toArray(new String[0]));
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u79fb\u9664\u6709\u5e8f\u96c6key\u4e2d\u7684\u4e00\u4e2a\u6216\u591a\u4e2a\u6210\u5458\u65f6\u51fa\u9519: key:{},members:{}", new Object[]{combineKey, members, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcard(combineKey);
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcard(combineKey);
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcard(combineKey);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u8fd4\u56de\u6709\u5e8f\u96c6key\u7684\u57fa\u6570\u65f6\u51fa\u9519: key:{}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zscore(String group, String key, String members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Double scroce = null;
            if (jds != null) {
                scroce = jds.zscore(combineKey, members);
            } else if (shardedJedis != null) {
                scroce = shardedJedis.zscore(combineKey, members);
            } else if (this.jedisCluster != null) {
                scroce = this.jedisCluster.zscore(combineKey, members);
            }
            Long l = scroce != null ? Long.valueOf(Math.round(scroce)) : null;
            return l;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u67e5\u8be2\u6709\u5e8f\u96c6key\u4e2d\uff0c\u6210\u5458member\u7684score\u503c\u65f6\u51fa\u9519: key:{},members:{}", new Object[]{combineKey, members, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String group, String key, Long min, Long max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcount(combineKey, (double)min.longValue(), (double)max.longValue());
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u6709\u5e8f\u96c6key\u4e2d\uff0cscore\u503c\u5728min\u548cmax\u4e4b\u95f4(\u9ed8\u8ba4\u5305\u62ecscore\u503c\u7b49\u4e8emin\u6216max)\u7684\u6210\u5458\u65f6\u51fa\u9519: key:{},min:{},max:{}", new Object[]{combineKey, min, max, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String group, String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                Long l = jds.zcount(combineKey, min, max);
                return l;
            }
            if (shardedJedis != null) {
                Long l = shardedJedis.zcount(combineKey, min, max);
                return l;
            }
            if (this.jedisCluster != null) {
                Long l = this.jedisCluster.zcount(combineKey, min, max);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u6709\u5e8f\u96c6key\u4e2d\uff0cscore\u503c\u5728min\u548cmax\u4e4b\u95f4(\u9ed8\u8ba4\u5305\u62ecscore\u503c\u7b49\u4e8emin\u6216max)\u7684\u6210\u5458\u65f6\u51fa\u9519: key:{},min:{},max:{}", new Object[]{combineKey, min, max, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(this.getGroup(), key, cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(String group, String key, String cursor) {
        Jedis jds = threadLocal.get();
        ShardedJedis shardedJedis = shardedThreadLocal.get();
        String combineKey = this.combineKey(group, key);
        try {
            if (jds == null) {
                jds = this.getJedis();
            }
            if (shardedJedis == null) {
                shardedJedis = this.getShardedJedis();
            }
            ScanResult result = null;
            ScanParams params = new ScanParams();
            if (jds != null) {
                threadLocal.set(jds);
                result = jds.zscan(combineKey, cursor, params.count(Integer.valueOf(1000)));
            } else if (shardedJedis != null) {
                shardedThreadLocal.set(shardedJedis);
                result = shardedJedis.zscan(combineKey, cursor, params.count(Integer.valueOf(1000)));
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zscan(combineKey, cursor);
            }
            if (result != null && "0".equals(result.getCursor())) {
                threadLocal.remove();
                shardedThreadLocal.remove();
            }
            ScanResult scanResult = result;
            return scanResult;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}, zscan\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeWithScores(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set<Object> list = new HashSet<Tuple>();
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                list = jds.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.zrangeWithScores(combineKey, start.longValue(), end.longValue());
            }
            Map<Long, String> map = RedisCache.getMap(list);
            return map;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u6b63\u5e8f\u5206\u9875\u65f6\u51fa\u9519\uff0ckey:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrevrangeWithScores(String group, String key, Long start, Long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set<Object> list = new HashSet<Tuple>();
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                list = jds.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (shardedJedis != null) {
                list = shardedJedis.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            } else if (this.jedisCluster != null) {
                list = this.jedisCluster.zrevrangeWithScores(combineKey, start.longValue(), end.longValue());
            }
            Map<Long, String> map = RedisCache.getMap(list);
            return map;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\u3001\u533a\u95f4\u5185\u53cd\u5e8f\u5206\u9875\u65f6\u51fa\u9519\uff0ckey:{},start:{},end:{}", new Object[]{combineKey, start, end, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(String group, String key, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long count = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                count = jds.setnx(combineKey, value);
            } else if (shardedJedis != null) {
                count = shardedJedis.setnx(combineKey, value);
            } else if (this.jedisCluster != null) {
                count = this.jedisCluster.setnx(combineKey, value);
            }
            Long l = count;
            return l;
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey SETNX\u65f6\u51fa\u9519\uff0ckey:{},value:{}", new Object[]{combineKey, value, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return null;
    }

    @Override
    public Transaction multi() {
        Jedis jds = threadLocal.get();
        if (jds == null && (jds = this.getJedis()) != null) {
            threadLocal.set(jds);
        }
        Transaction transaction = null;
        try {
            if (jds != null) {
                transaction = jds.multi();
            }
            return transaction;
        }
        catch (Exception e) {
            logger.error("\u6253\u5f00\u4e8b\u52a1\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    public void shutdown() {
        Jedis jds = threadLocal.get();
        this.shutdown(jds, null);
        threadLocal.remove();
    }

    @Override
    public String watch(String ... key) {
        Jedis jds = threadLocal.get();
        if (jds == null) {
            try {
                jds = this.getJedis();
                if (jds != null) {
                    threadLocal.set(jds);
                    return jds.watch(key);
                }
                logger.error("\u83b7\u53d6\u4e0d\u5230redis\u8fde\u63a5");
                return null;
            }
            catch (Exception e) {
                logger.error("watch\u51fa\u9519", (Throwable)e);
                return null;
            }
        }
        return jds.watch(key);
    }

    @Override
    public void unwatch() {
        Jedis jds = threadLocal.get();
        if (jds != null) {
            jds.unwatch();
        }
    }

    private Map<String, Double> getMap(Map<String, Long> scoreMembers) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (!CollectionUtils.isEmpty(scoreMembers)) {
            for (Map.Entry<String, Long> m : scoreMembers.entrySet()) {
                map.put(m.getKey(), (double)m.getValue());
            }
        }
        return map;
    }

    private static Map<Long, String> getMap(Set<Tuple> list) {
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>();
        for (Tuple tuple : list) {
            map.put(Math.round(tuple.getScore()), tuple.getElement());
        }
        return map;
    }

    public Set<String> getKeys(String pattern, ShardedJedis shardedJedis) {
        HashSet<String> list = new HashSet<String>();
        Collection allShards = shardedJedis.getAllShards();
        for (Jedis jedis : allShards) {
            Set keys = jedis.keys(pattern);
            list.addAll(keys);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys(String pattern) {
        logger.debug("Start getting keys...");
        HashSet<String> keys = new HashSet<String>();
        Map clusterNodes = this.jedisCluster.getClusterNodes();
        for (String k : clusterNodes.keySet()) {
            logger.debug("Getting keys from: {}", (Object)k);
            JedisPool jp = (JedisPool)clusterNodes.get(k);
            Jedis connection = jp.getResource();
            try {
                keys.addAll(connection.keys(pattern));
            }
            catch (Exception e) {
                logger.error("Getting keys error: ", (Throwable)e);
            }
            finally {
                logger.debug("Connection closed.");
                connection.close();
            }
        }
        logger.debug("Keys gotten!");
        return keys;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.hgetAll(this.getGroup(), key);
    }

    @Override
    public Map<String, String> hgetAll(String group, String key) {
        logger.debug("start to hgetall---------");
        String combineKey = this.combineKey(group, key);
        Map content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (jds != null) {
                content = jds.hgetAll(combineKey);
            } else if (shardedJedis != null) {
                content = shardedJedis.hgetAll(combineKey);
            } else if (this.jedisCluster != null) {
                content = this.jedisCluster.hgetAll(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey\uff1a{}\uff0chgetAll\u5f02\u5e38", (Object)key, (Object)e);
        }
        return content;
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(this.getGroup(), key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String group, String key, String cursor) {
        logger.debug("start to hscan-------");
        String combineKey = this.combineKey(group, key);
        ScanResult content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hscan(combineKey, cursor);
            } else if (null != shardedJedis) {
                content = shardedJedis.hscan(combineKey, cursor);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hscan(combineKey, cursor);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chscan\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return content;
    }

    @Override
    public List<String> hmget(String key, String[] fields) {
        return this.hmget(this.getGroup(), key, fields);
    }

    @Override
    public List<String> hmget(String group, String key, String[] fields) {
        logger.debug("start to hmget return List<String>-----------------------");
        String combineKey = this.combineKey(group, key);
        List content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hmget(combineKey, fields);
            } else if (null != shardedJedis) {
                content = shardedJedis.hmget(combineKey, fields);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hmget(combineKey, fields);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chmget\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return content;
    }

    @Override
    public <T> Map<String, T> hmget(String key, String[] fields, Class<T> clazz) {
        return this.hmget(this.getGroup(), key, fields, clazz);
    }

    @Override
    public <T> Map<String, T> hmget(String group, String key, String[] fields, Class<T> clazz) {
        logger.debug("start to hmget return Map<String, T>-----------------------");
        String combineKey = this.combineKey(group, key);
        List content = null;
        HashMap<String, Object> response = new HashMap<String, Object>();
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hmget(combineKey, fields);
            } else if (null != shardedJedis) {
                content = shardedJedis.hmget(combineKey, fields);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hmget(combineKey, fields);
            }
            if (null != fields && fields.length > 0 && !CollectionUtils.isEmpty((Collection)content)) {
                for (int i = 0; i < fields.length; ++i) {
                    response.put(fields[i], StringUtils.isNotEmpty((CharSequence)((CharSequence)content.get(i))) ? JacksonUtil.readValue((String)((String)content.get(i)), clazz) : null);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chmget\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return response;
    }

    @Override
    public <T> Map<String, List<T>> hmget(String key, String[] fields, TypeReference<List<T>> typeReference) {
        return this.hmget(this.getGroup(), key, fields, typeReference);
    }

    @Override
    public <T> Map<String, List<T>> hmget(String group, String key, String[] fields, TypeReference<List<T>> typeReference) {
        logger.debug("start to hmget return Map<String, T>-----------------------");
        String combineKey = this.combineKey(group, key);
        List content = null;
        HashMap<String, List<T>> response = new HashMap<String, List<T>>();
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hmget(combineKey, fields);
            } else if (null != shardedJedis) {
                content = shardedJedis.hmget(combineKey, fields);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hmget(combineKey, fields);
            }
            if (null != fields && fields.length > 0 && !CollectionUtils.isEmpty((Collection)content)) {
                for (int i = 0; i < fields.length; ++i) {
                    response.put(fields[i], StringUtils.isNotEmpty((CharSequence)((CharSequence)content.get(i))) ? (List)JacksonUtil.readValue((String)((String)content.get(i)), typeReference) : null);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chmget\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return response;
    }

    @Override
    public Set<String> hkeys(String key) {
        return this.hkeys(this.getGroup(), key);
    }

    @Override
    public Set<String> hkeys(String group, String key) {
        logger.debug("start to hkeys------------------");
        String combineKey = this.combineKey(group, key);
        Set content = null;
        try (Jedis jds = this.getJedis();
             ShardedJedis shardedJedis = this.getShardedJedis();){
            if (null != jds) {
                content = jds.hkeys(combineKey);
            } else if (null != shardedJedis) {
                content = shardedJedis.hkeys(combineKey);
            } else if (null != this.jedisCluster) {
                content = this.jedisCluster.hkeys(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9akey:{}\uff0chkeys\u5f02\u5e38", (Object)combineKey, (Object)e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getToLiveTime(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.ttl(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.ttl(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.ttl(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4\u51fa\u9519: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(String group, String channel, IRedisSubProcessor<String> processor) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineChannel = this.combineKey(group, channel);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.subscribe(ListenerConver.conver(processor), new String[]{combineChannel});
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    this.jedisCluster.subscribe(ListenerConver.conver(processor), new String[]{combineChannel});
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u9605\u6d88\u606f\u5f02\u5e38: channel={}", (Object)combineChannel, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String group, String channel, String message) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineChannel = this.combineKey(group, channel);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.publish(combineChannel, message);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    this.jedisCluster.publish(combineChannel, message);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u5e03\u6d88\u606f\u5f02\u5e38: channel={}", (Object)combineChannel, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mset(String group, Map<String, String> dataMap) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        boolean flag = false;
        String[] combineKeysvalues = this.combineKeyValues(group, dataMap);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.mset(combineKeysvalues);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.mset(combineKeysvalues);
                }
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("mset\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public boolean hmset(String key, Map<String, String> dataMap) {
        return this.hmset(this.group, key, dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hmset(String group, String key, Map<String, String> dataMap) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        boolean flag = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hmset(combineKey, dataMap);
            } else if (shardedJedis != null) {
                result = shardedJedis.hmset(combineKey, dataMap);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hmset(combineKey, dataMap);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("mset\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pfadd(String group, String key, String[] elements) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        long result = 0L;
        boolean flag = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.pfadd(combineKey, elements);
            } else if (shardedJedis != null) {
                result = shardedJedis.pfadd(combineKey, elements);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.pfadd(combineKey, elements);
            }
            if (result == 1L) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("pfadd\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long pfcount(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                long l = jds.pfcount(combineKey);
                return l;
            }
            if (shardedJedis != null) {
                long l = shardedJedis.pfcount(combineKey);
                return l;
            }
            if (this.jedisCluster != null) {
                long l = this.jedisCluster.pfcount(combineKey);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("pfcount\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long pfcount(String group, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                long l = jds.pfcount(combineKeys);
                return l;
            }
            if (shardedJedis != null) {
                throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
            }
            if (this.jedisCluster != null) {
                long l = this.jedisCluster.pfcount(combineKeys);
                return l;
            }
        }
        catch (Exception e) {
            logger.error("pfcount\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pfmerge(String group, String destKey, String[] sourceKeys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String combineDestKey = this.combineKey(group, destKey);
        String[] combineSourceKeys = this.combineKeys(group, sourceKeys);
        String result = "";
        boolean flag = false;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.pfmerge(combineDestKey, combineSourceKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.pfmerge(combineDestKey, combineSourceKeys);
                }
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("pfmerge\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public void subscribeKeyExpiredEvent(IRedisSubProcessor<String> processor) {
        String group = String.format("__keyevent@%d__", this.dbIndex);
        this.subscribe(group, "expired", processor);
    }

    @Override
    public boolean exists(String key) {
        return this.exists(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        boolean flag = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                flag = jds.exists(combineKey);
            } else if (shardedJedis != null) {
                flag = shardedJedis.exists(combineKey);
            } else if (this.jedisCluster != null) {
                flag = this.jedisCluster.exists(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public String type(String key) {
        return this.type(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String type = "";
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                type = jds.type(combineKey);
            } else if (shardedJedis != null) {
                type = shardedJedis.type(combineKey);
            } else if (this.jedisCluster != null) {
                type = this.jedisCluster.type(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return type;
    }

    @Override
    public boolean rename(String oldKey, String newKey) {
        return this.rename(this.group, oldKey, newKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String group, String oldKey, String newKey) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        boolean flag = false;
        String oldCombineKey = this.combineKey(group, oldKey);
        String newCombineKey = this.combineKey(group, newKey);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.rename(oldCombineKey, newCombineKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.rename(oldCombineKey, newCombineKey);
                }
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("rename\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public Long renamenx(String oldKey, String newKey) {
        return this.renamenx(this.group, oldKey, newKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long renamenx(String group, String oldKey, String newKey) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String oldCombineKey = this.combineKey(group, oldKey);
        String newCombineKey = this.combineKey(group, newKey);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.renamenx(oldCombineKey, newCombineKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.renamenx(oldCombineKey, newCombineKey);
                }
            }
        }
        catch (Exception e) {
            logger.error("renamenx\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        return this.getrange(this.group, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getrange(String group, String key, long startOffset, long endOffset) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.getrange(combineKey, startOffset, endOffset);
            } else if (shardedJedis != null) {
                result = shardedJedis.getrange(combineKey, startOffset, endOffset);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.getrange(combineKey, startOffset, endOffset);
            }
        }
        catch (Exception e) {
            logger.error("getrange\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.decr(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.decr(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.decr(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("decr\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(String key, long integer) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.decrBy(combineKey, integer);
            } else if (shardedJedis != null) {
                result = shardedJedis.decrBy(combineKey, integer);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.decrBy(combineKey, integer);
            }
        }
        catch (Exception e) {
            logger.error("decrBy\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long strlen(String key) {
        return this.strlen(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long strlen(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.strlen(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.strlen(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.strlen(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("strlen\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean msetnx(String group, Map<String, String> dataMap) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = 0L;
        boolean flag = false;
        String[] combineKeysvalues = this.combineKeyValues(group, dataMap);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.msetnx(combineKeysvalues);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.msetnx(combineKeysvalues);
                }
            }
            if (result == 1L) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("msetnx\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public boolean msetnx(Map<String, String> dataMap) {
        return this.msetnx(this.group, dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setrange(String group, String key, long offset, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.setrange(combineKey, offset, value);
            } else if (shardedJedis != null) {
                result = shardedJedis.setrange(combineKey, offset, value);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.setrange(combineKey, offset, value);
            }
        }
        catch (Exception e) {
            logger.error("setrange\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return this.setrange(this.group, key, offset, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long append(String group, String key, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.append(combineKey, value);
            } else if (shardedJedis != null) {
                result = shardedJedis.append(combineKey, value);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.append(combineKey, value);
            }
        }
        catch (Exception e) {
            logger.error("append\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long append(String key, String value) {
        return this.append(this.group, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSet(String group, String key, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.getSet(combineKey, value);
            } else if (shardedJedis != null) {
                result = shardedJedis.getSet(combineKey, value);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.getSet(combineKey, value);
            }
        }
        catch (Exception e) {
            logger.error("getSet\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String getSet(String key, String value) {
        return this.getSet(this.group, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lindex(String group, String key, long index) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.lindex(combineKey, index);
            } else if (shardedJedis != null) {
                result = shardedJedis.lindex(combineKey, index);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.lindex(combineKey, index);
            }
        }
        catch (Exception e) {
            logger.error("lindex\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String lindex(String key, long index) {
        return this.lindex(this.group, key, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpoplpush(String srckey, String dstkey) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String srcCombineKey = this.combineKey(this.group, srckey);
        String dstCombineKey = this.combineKey(this.group, dstkey);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.rpoplpush(srcCombineKey, dstCombineKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.rpoplpush(srcCombineKey, dstCombineKey);
                }
            }
        }
        catch (Exception e) {
            logger.error("rpoplpush\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String[] args) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String[] combineKey = this.combineKeys(this.group, args);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.blpop(combineKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    throw new RuntimeException("jedisCluster\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("blpop\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        String[] keys = new String[]{key};
        return this.blpop(timeout, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(int timeout, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String[] combineKeys = this.combineKeys(this.group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.blpop(timeout, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.blpop(timeout, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("blpop\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String[] args) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String[] combineKey = this.combineKeys(this.group, args);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.brpop(combineKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    throw new RuntimeException("jedisCluster\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("brpop\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        String[] keys = new String[]{key};
        return this.brpop(timeout, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(int timeout, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String[] combineKeys = this.combineKeys(this.group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.brpop(timeout, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.brpop(timeout, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("brpop\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String srcCombineKey = this.combineKey(this.group, source);
        String dstCombineKey = this.combineKey(this.group, destination);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.brpoplpush(srcCombineKey, dstCombineKey, timeout);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.brpoplpush(srcCombineKey, dstCombineKey, timeout);
                }
            }
        }
        catch (Exception e) {
            logger.error("brpoplpush\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(String group, String key, long count, String value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.lrem(combineKey, count, value);
            } else if (shardedJedis != null) {
                result = shardedJedis.lrem(combineKey, count, value);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.lrem(combineKey, count, value);
            }
        }
        catch (Exception e) {
            logger.error("lrem\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return this.lrem(this.group, key, count, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.llen(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.llen(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.llen(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("llen\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long llen(String key) {
        return this.llen(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ltrim(String group, String key, long start, long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        boolean flag = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.ltrim(combineKey, start, end);
            } else if (shardedJedis != null) {
                result = shardedJedis.ltrim(combineKey, start, end);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.ltrim(combineKey, start, end);
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("ltrim\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public boolean ltrim(String key, long start, long end) {
        return this.ltrim(this.group, key, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.lpop(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.lpop(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.lpop(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("lpop\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String lpop(String key) {
        return this.lpop(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.rpop(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.rpop(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.rpop(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("rpop\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String rpop(String key) {
        return this.rpop(this.group, key);
    }

    @Override
    public <T> Long lpushx(String key, List<T> valueList) {
        return this.lpushx(this.group, key, valueList, 0);
    }

    @Override
    public <T> Long lpushx(String key, List<T> valueList, int seconds) {
        return this.lpushx(this.group, key, valueList, seconds);
    }

    @Override
    public <T> Long lpushx(String group, String key, List<T> valueList) {
        return this.lpushx(group, key, valueList, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Long lpushx(String group, String key, List<T> valueList, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (valueList != null && !valueList.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    String[] obj = this.getList(valueList);
                    jds.lpushx(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    String[] obj = this.getList(valueList);
                    shardedJedis.lpushx(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    String[] obj = this.getList(valueList);
                    this.jedisCluster.lpushx(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217lpushx \u987a\u5e8f\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public <T> Long rpushx(String key, List<T> valueList) {
        return this.rpushx(this.group, key, valueList, 0);
    }

    @Override
    public <T> Long rpushx(String key, List<T> valueList, int seconds) {
        return this.rpushx(this.group, key, valueList, seconds);
    }

    @Override
    public <T> Long rpushx(String group, String key, List<T> valueList) {
        return this.rpushx(group, key, valueList, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Long rpushx(String group, String key, List<T> valueList, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (valueList != null && !valueList.isEmpty()) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    String[] obj = this.getList(valueList);
                    jds.rpushx(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    String[] obj = this.getList(valueList);
                    shardedJedis.rpushx(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    String[] obj = this.getList(valueList);
                    this.jedisCluster.rpushx(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("REDIS\u961f\u5217rpushx \u987a\u5e8f\u5b58\u50a8\u51fa\u9519: key={}", (Object)combineKey, (Object)e);
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean lset(String group, String key, long index, T value) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = "";
        boolean flag = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.lset(combineKey, index, JacksonUtil.toJson(value));
            } else if (shardedJedis != null) {
                result = shardedJedis.lset(combineKey, index, JacksonUtil.toJson(value));
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.lset(combineKey, index, JacksonUtil.toJson(value));
            }
            if ("OK".equalsIgnoreCase(result)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("lset\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return flag;
    }

    @Override
    public <T> boolean lset(String key, long index, T value) {
        return this.lset(this.group, key, index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hexists(String group, String key, String field) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Boolean result = false;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hexists(combineKey, field);
            } else if (shardedJedis != null) {
                result = shardedJedis.hexists(combineKey, field);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hexists(combineKey, field);
            }
        }
        catch (Exception e) {
            logger.error("hexists\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.hexists(this.group, key, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hlen(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.hlen(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hlen(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("hlen\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long hlen(String key) {
        return this.hlen(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hvals(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hvals(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.hvals(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hvals(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("hvals\u5f02\u5e38: key={}", (Object)key, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public List<String> hvals(String key) {
        return this.hvals(this.group, key);
    }

    @Override
    public <T> Long hsetnx(String key, String field, T value) {
        return this.hsetnx(this.group, key, field, value, 0);
    }

    @Override
    public <T> Long hsetnx(String key, String field, T value, int seconds) {
        return this.hsetnx(this.group, key, field, value, seconds);
    }

    @Override
    public <T> Long hsetnx(String group, String key, String field, T value) {
        return this.hsetnx(group, key, field, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Long hsetnx(String group, String key, String field, T value, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        String jsonValue = JacksonUtil.toJson(value);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.hsetnx(combineKey, field, jsonValue);
                this.expire(seconds, jds, combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.hsetnx(combineKey, field, jsonValue);
                this.expire(seconds, shardedJedis, combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.hsetnx(combineKey, field, jsonValue);
                this.expire(seconds, this.jedisCluster, combineKey);
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6emap\u5143\u7d20\u6570\u636e\u51fa\u9519: group={}, key={}, value={}", new Object[]{group, key, jsonValue, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public <T> Long sadd(String key, List<T> members) {
        return this.sadd(this.group, key, members, 0);
    }

    @Override
    public <T> Long sadd(String key, List<T> members, int seconds) {
        return this.sadd(this.group, key, members, seconds);
    }

    @Override
    public <T> Long sadd(String group, String key, List<T> members) {
        return this.sadd(group, key, members, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Long sadd(String group, String key, List<T> members, int seconds) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            if (!CollectionUtils.isEmpty(members)) {
                jds = this.getJedis();
                shardedJedis = this.getShardedJedis();
                if (jds != null) {
                    String[] obj = this.getList(members);
                    jds.sadd(combineKey, obj);
                    this.expire(seconds, jds, combineKey);
                } else if (shardedJedis != null) {
                    String[] obj = this.getList(members);
                    shardedJedis.sadd(combineKey, obj);
                    this.expire(seconds, shardedJedis, combineKey);
                } else if (this.jedisCluster != null) {
                    String[] obj = this.getList(members);
                    this.jedisCluster.sadd(combineKey, obj);
                    this.expire(seconds, this.jedisCluster, combineKey);
                }
            }
            this.shutdown(jds, shardedJedis);
        }
        catch (Exception e) {
            try {
                logger.error("sadd\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
                this.shutdown(jds, shardedJedis);
            }
            catch (Throwable throwable) {
                this.shutdown(jds, shardedJedis);
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public Set<String> smembers(String key) {
        return this.smembers(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.smembers(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.smembers(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.smembers(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("smembers\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long srem(String key, String[] members) {
        return this.srem(this.group, key, members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(String group, String key, String[] members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.srem(combineKey, members);
            } else if (shardedJedis != null) {
                result = shardedJedis.srem(combineKey, members);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.srem(combineKey, members);
            }
        }
        catch (Exception e) {
            logger.error("srem\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String spop(String key) {
        return this.spop(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.spop(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.spop(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.spop(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("spop\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Set<String> spop(String key, long count) {
        return this.spop(this.group, key, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> spop(String group, String key, long count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.spop(combineKey, count);
            } else if (shardedJedis != null) {
                result = shardedJedis.spop(combineKey, count);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.spop(combineKey, count);
            }
        }
        catch (Exception e) {
            logger.error("spop\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long smove(String srckey, String dstkey, String member) {
        return this.smove(this.group, srckey, dstkey, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long smove(String group, String srckey, String dstkey, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineSrcKey = this.combineKey(group, srckey);
        String combineDstKey = this.combineKey(group, dstkey);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.smove(combineSrcKey, combineDstKey, member);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.smove(combineSrcKey, combineDstKey, member);
                }
            }
        }
        catch (Exception e) {
            logger.error("smove\u51fa\u9519: group={}, srckey={}, dstkey={}", new Object[]{group, srckey, dstkey, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long scard(String key) {
        return this.scard(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.scard(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.scard(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.scard(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("scard\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.sismember(this.group, key, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sismember(String group, String key, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Boolean result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sismember(combineKey, member);
            } else if (shardedJedis != null) {
                result = shardedJedis.sismember(combineKey, member);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.sismember(combineKey, member);
            }
        }
        catch (Exception e) {
            logger.error("sismember\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Set<String> sinter(String[] keys) {
        return this.sinter(this.group, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> sinter(String group, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sinter(combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sinter(combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sinter\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long sinterstore(String dstkey, String[] keys) {
        return this.sinterstore(this.group, dstkey, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sinterstore(String group, String dstkey, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sinterstore(dstkey, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sinterstore(dstkey, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sinterstore\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Set<String> sunion(String[] keys) {
        return this.sunion(this.group, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> sunion(String group, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sunion(combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sunion(combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sunion\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long sunionstore(String dstkey, String[] keys) {
        return this.sunionstore(this.group, dstkey, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sunionstore(String group, String dstkey, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sunionstore(dstkey, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sunionstore(dstkey, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sunionstore\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Set<String> sdiff(String[] keys) {
        return this.sdiff(this.group, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> sdiff(String group, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sdiff(combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sdiff(combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sdiff\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long sdiffstore(String dstkey, String[] keys) {
        return this.sdiffstore(this.group, dstkey, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sdiffstore(String group, String dstkey, String[] keys) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String[] combineKeys = this.combineKeys(group, keys);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sdiffstore(dstkey, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sdiffstore(dstkey, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("sdiffstore\u51fa\u9519: group={}, keys={}", new Object[]{group, keys, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public String srandmember(String key) {
        return this.srandmember(this.group, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String srandmember(String group, String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        String result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.srandmember(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.srandmember(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.srandmember(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("srandmember\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public List<String> srandmember(String key, int count) {
        return this.srandmember(this.group, key, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> srandmember(String group, String key, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.srandmember(combineKey, count);
            } else if (shardedJedis != null) {
                result = shardedJedis.srandmember(combineKey, count);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.srandmember(combineKey, count);
            }
        }
        catch (Exception e) {
            logger.error("srandmember\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.zincrby(this.group, key, score, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String group, String key, double score, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Double result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zincrby(combineKey, score, member);
            } else if (shardedJedis != null) {
                result = shardedJedis.zincrby(combineKey, score, member);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zincrby(combineKey, score, member);
            }
        }
        catch (Exception e) {
            logger.error("zincrby\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zrank(String key, String member) {
        return this.zrank(this.group, key, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(String group, String key, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrank(combineKey, member);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrank(combineKey, member);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrank(combineKey, member);
            }
        }
        catch (Exception e) {
            logger.error("zrank\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zrevrank(String key, String member) {
        return this.zrevrank(this.group, key, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(String group, String key, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrevrank(combineKey, member);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrevrank(combineKey, member);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrevrank(combineKey, member);
            }
        }
        catch (Exception e) {
            logger.error("zrevrank\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        return this.zlexcount(this.group, key, min, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zlexcount(String group, String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zlexcount(combineKey, min, max);
            } else if (shardedJedis != null) {
                result = shardedJedis.zlexcount(combineKey, min, max);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zlexcount(combineKey, min, max);
            }
        }
        catch (Exception e) {
            logger.error("zlexcount\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zunionstore(String dstkey, String[] sets) {
        return this.zunionstore(this.group, dstkey, sets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zunionstore(String group, String dstkey, String[] sets) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, dstkey);
        String[] combineKeys = this.combineKeys(group, sets);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zunionstore(combineKey, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.zunionstore(combineKey, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("zunionstore\u51fa\u9519: group={}, key={}", new Object[]{group, dstkey, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        return this.zremrangeByRank(this.group, key, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByRank(String group, String key, long start, long end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zremrangeByRank(combineKey, start, end);
            } else if (shardedJedis != null) {
                result = shardedJedis.zremrangeByRank(combineKey, start, end);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zremrangeByRank(combineKey, start, end);
            }
        }
        catch (Exception e) {
            logger.error("zremrangeByRank\u51fa\u9519: group={}, key={}", new Object[]{group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Long zinterstore(String dstkey, String[] sets) {
        return this.zinterstore(this.group, dstkey, sets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zinterstore(String group, String dstkey, String[] sets) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(group, dstkey);
        String[] combineKeys = this.combineKeys(group, sets);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zinterstore(combineKey, combineKeys);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.zinterstore(combineKey, combineKeys);
                }
            }
        }
        catch (Exception e) {
            logger.error("zinterstore\u51fa\u9519: group={}, key={}", new Object[]{group, dstkey, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByScore(key, min, max);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByScore(key, min, max);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByScore(key, min, max);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByScore(key, min, max);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByScore(key, min, max);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByScore(key, min, max);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByScore(key, min, max, offset, count);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByScore(key, min, max, offset, count);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByScore(key, min, max, offset, count);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByScore(key, min, max, offset, count);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByScore(key, min, max, offset, count);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByScore(key, min, max, offset, count);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeByScoreWithScores(String key, double min, double max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Map<Long, String> result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Set tupleSet = null;
            if (jds != null) {
                tupleSet = jds.zrangeByScoreWithScores(key, min, max);
            } else if (shardedJedis != null) {
                tupleSet = shardedJedis.zrangeByScoreWithScores(key, min, max);
            } else if (this.jedisCluster != null) {
                tupleSet = this.jedisCluster.zrangeByScoreWithScores(key, min, max);
            }
            result = RedisCache.getMap(tupleSet);
        }
        catch (Exception e) {
            logger.error("zrangeByScoreWithScores\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeByScoreWithScores(String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Map<Long, String> result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Set tupleSet = null;
            if (jds != null) {
                tupleSet = jds.zrangeByScoreWithScores(key, min, max);
            } else if (shardedJedis != null) {
                tupleSet = shardedJedis.zrangeByScoreWithScores(key, min, max);
            } else if (this.jedisCluster != null) {
                tupleSet = this.jedisCluster.zrangeByScoreWithScores(key, min, max);
            }
            result = RedisCache.getMap(tupleSet);
        }
        catch (Exception e) {
            logger.error("zrangeByScoreWithScores\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Map<Long, String> result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Set tupleSet = null;
            if (jds != null) {
                tupleSet = jds.zrangeByScoreWithScores(key, min, max, offset, count);
            } else if (shardedJedis != null) {
                tupleSet = shardedJedis.zrangeByScoreWithScores(key, min, max, offset, count);
            } else if (this.jedisCluster != null) {
                tupleSet = this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
            }
            result = RedisCache.getMap(tupleSet);
        }
        catch (Exception e) {
            logger.error("zrangeByScoreWithScores\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Map<Long, String> result = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            Set tupleSet = null;
            if (jds != null) {
                tupleSet = jds.zrangeByScoreWithScores(key, min, max, offset, count);
            } else if (shardedJedis != null) {
                tupleSet = shardedJedis.zrangeByScoreWithScores(key, min, max, offset, count);
            } else if (this.jedisCluster != null) {
                tupleSet = this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
            }
            result = RedisCache.getMap(tupleSet);
        }
        catch (Exception e) {
            logger.error("zrangeByScoreWithScores\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zremrangeByScore(combineKey, start, end);
            } else if (shardedJedis != null) {
                result = shardedJedis.zremrangeByScore(combineKey, start, end);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zremrangeByScore(combineKey, start, end);
            }
        }
        catch (Exception e) {
            logger.error("zremrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zremrangeByScore(combineKey, start, end);
            } else if (shardedJedis != null) {
                result = shardedJedis.zremrangeByScore(combineKey, start, end);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zremrangeByScore(combineKey, start, end);
            }
        }
        catch (Exception e) {
            logger.error("zremrangeByScore\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByLex(combineKey, min, max);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByLex(combineKey, min, max);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByLex(combineKey, min, max);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByLex\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Set result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zrangeByLex(combineKey, min, max, offset, count);
            } else if (shardedJedis != null) {
                result = shardedJedis.zrangeByLex(combineKey, min, max, offset, count);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zrangeByLex(combineKey, min, max, offset, count);
            }
        }
        catch (Exception e) {
            logger.error("zrangeByLex\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.zremrangeByLex(combineKey, min, max);
            } else if (shardedJedis != null) {
                result = shardedJedis.zremrangeByLex(combineKey, min, max);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.zremrangeByLex(combineKey, min, max);
            }
        }
        catch (Exception e) {
            logger.error("zremrangeByLex\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void psubscribe(IRedisSubProcessor<String> processor, String[] patterns) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                jds.psubscribe(ListenerConver.conver(processor), patterns);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    this.jedisCluster.psubscribe(ListenerConver.conver(processor), patterns);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u9605\u6d88\u606f\u5f02\u5e38: patterns={}", (Object)patterns, (Object)e);
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.geoadd(combineKey, longitude, latitude, member);
            } else if (shardedJedis != null) {
                result = shardedJedis.geoadd(combineKey, longitude, latitude, member);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.geoadd(combineKey, longitude, latitude, member);
            }
        }
        catch (Exception e) {
            logger.error("geoadd\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.geoadd(combineKey, memberCoordinateMap);
            } else if (shardedJedis != null) {
                result = shardedJedis.geoadd(combineKey, memberCoordinateMap);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.geoadd(combineKey, memberCoordinateMap);
            }
        }
        catch (Exception e) {
            logger.error("geoadd\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        return this.geodist(key, member1, member2, GeoUnit.M);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Double result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.geodist(combineKey, member1, member2, unit);
            } else if (shardedJedis != null) {
                result = shardedJedis.geodist(combineKey, member1, member2, unit);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.geodist(combineKey, member1, member2, unit);
            }
        }
        catch (Exception e) {
            logger.error("geodist\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> geohash(String key, String[] members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.geohash(combineKey, members);
            } else if (shardedJedis != null) {
                result = shardedJedis.geohash(combineKey, members);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.geohash(combineKey, members);
            }
        }
        catch (Exception e) {
            logger.error("geohash\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoCoordinate> geopos(String key, String[] members) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.geopos(combineKey, members);
            } else if (shardedJedis != null) {
                result = shardedJedis.geopos(combineKey, members);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.geopos(combineKey, members);
            }
        }
        catch (Exception e) {
            logger.error("geopos\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.georadius(combineKey, longitude, latitude, radius, unit);
            } else if (shardedJedis != null) {
                result = shardedJedis.georadius(combineKey, longitude, latitude, radius, unit);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.georadius(combineKey, longitude, latitude, radius, unit);
            }
        }
        catch (Exception e) {
            logger.error("georadius\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.georadiusByMember(combineKey, member, radius, unit);
            } else if (shardedJedis != null) {
                result = shardedJedis.georadiusByMember(combineKey, member, radius, unit);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.georadiusByMember(combineKey, member, radius, unit);
            }
        }
        catch (Exception e) {
            logger.error("georadiusByMember\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expireAt(String key, long unixTime) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.expireAt(combineKey, unixTime);
            } else if (shardedJedis != null) {
                result = shardedJedis.expireAt(combineKey, unixTime);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.expireAt(combineKey, unixTime);
            }
        }
        catch (Exception e) {
            logger.error("expireAt\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> sort(String key) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        List result = null;
        String combineKey = this.combineKey(this.group, key);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sort(combineKey);
            } else if (shardedJedis != null) {
                result = shardedJedis.sort(combineKey);
            } else if (this.jedisCluster != null) {
                result = this.jedisCluster.sort(combineKey);
            }
        }
        catch (Exception e) {
            logger.error("sort\u51fa\u9519: group={}, key={}", new Object[]{this.group, key, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sort(String key, String dstkey) {
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        Long result = null;
        String combineKey = this.combineKey(this.group, key);
        String combineDstKey = this.combineKey(this.group, dstkey);
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.sort(combineKey, combineDstKey);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.sort(combineKey, combineDstKey);
                }
            }
        }
        catch (Exception e) {
            logger.error("sort\u51fa\u9519: group={}, key={}, dstkey={}", new Object[]{this.group, key, dstkey, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        Object result = null;
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            if (jds != null) {
                result = jds.eval(script, keys, args);
            } else {
                if (shardedJedis != null) {
                    throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301eval\u65b9\u6cd5\uff01");
                }
                if (this.jedisCluster != null) {
                    result = this.jedisCluster.eval(script, keys, args);
                }
            }
        }
        catch (Exception e) {
            logger.error("eval\u51fa\u9519: script={}, keys={}, args={}", new Object[]{script, keys, args, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return result;
    }

    private static boolean periodLimit(String key, int maxCount, int period, long nowTs, JedisCommands jedis) {
        jedis.zremrangeByScore(key, 0.0, (double)(nowTs - (long)(period * 1000)));
        Long zcard = jedis.zcard(key);
        if (zcard != null && zcard < (long)maxCount) {
            jedis.zadd(key, (double)nowTs, UUID.randomUUID().toString());
            jedis.expire(key, period);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean periodLimiting(String key, int maxCount, int period) {
        if (maxCount > 20000) {
            throw new RuntimeException("");
        }
        Jedis jds = null;
        ShardedJedis shardedJedis = null;
        try {
            jds = this.getJedis();
            shardedJedis = this.getShardedJedis();
            long nowTs = System.currentTimeMillis();
            if (jds != null) {
                boolean bl = RedisCache.periodLimit(key, maxCount, period, nowTs, (JedisCommands)jds);
                return bl;
            }
            if (shardedJedis != null) {
                throw new RuntimeException("shardedJedis\u4e0d\u652f\u6301periodLimiting\uff01");
            }
            if (this.jedisCluster != null) {
                Iterator iterator = this.jedisCluster.getClusterNodes().values().iterator();
                if (iterator.hasNext()) {
                    Jedis jedis = ((JedisPool)iterator.next()).getResource();
                    boolean bl = RedisCache.periodLimit(key, period, maxCount, nowTs, (JedisCommands)jedis);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("periodLimiting\u51fa\u9519: key={}, period={}, maxCount={}", new Object[]{key, period, maxCount, e});
        }
        finally {
            this.shutdown(jds, shardedJedis);
        }
        return false;
    }
}

