/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.comm.util;

import java.net.URLEncoder;

public class WeixinApi {
    private static final String GET_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String GET_OAUTH_CODE = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=%s&scope=%s&state=%s#wechat_redirect";
    private static final String GET_OAUTH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String GET_OAUTH_USERINFO = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";
    private static final String GET_JSAPI_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
    private static final String GET_USERINFO = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN";
    private static final String GET_TEMPORARY_MEDIA = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=%s&media_id=%s";
    private static final String SEND_TEMPLATE_MESSAGE = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=%s";

    public static String getTokenUrl(String APPID, String APPSECRET) {
        return String.format(GET_TOKEN, APPID, APPSECRET);
    }

    public static String getOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format(GET_OAUTH_CODE, APPID, WeixinApi.urlEnodeUTF8(redirectUrl), "code", scope, state);
    }

    public static String getOAuthTokenUrl(String APPID, String APPSECRET, String code) {
        return String.format(GET_OAUTH_TOKEN, APPID, APPSECRET, code);
    }

    public static String getOAuthUserinfoUrl(String oAuthToken, String openid) {
        return String.format(GET_OAUTH_USERINFO, oAuthToken, openid);
    }

    public static String getJsApiTicketUrl(String token) {
        return String.format(GET_JSAPI_TICKET, token);
    }

    public static String getUserinfoUrl(String token, String openid) {
        return String.format(GET_USERINFO, token, openid);
    }

    public static String getTemporaryMediaUrl(String token, String mediaId) {
        return String.format(GET_TEMPORARY_MEDIA, token, mediaId);
    }

    public static String getSendTemplateMessageUrl(String token) {
        return String.format(SEND_TEMPLATE_MESSAGE, token);
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

