/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.eo;

import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseDefEo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.ColumnInfo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.eo.TableInfo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.net.LocalIpAddress;
import com.dtyunxi.util.SqlUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class BaseEoUtil {
    private static Logger logger = LoggerFactory.getLogger(BaseEoUtil.class);
    private static String workerId = null;
    private static final Map<String, TableInfo> tables = new ConcurrentHashMap<String, TableInfo>();
    private static final Random random = new Random();
    private static List<ColumnInfo> baseColumns;
    private static final SimpleDateFormat SDF_DATETIME;
    private static final SimpleDateFormat SDF_DATE;

    public static Long getWorkerId() {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)workerId)) {
            return Long.valueOf(workerId);
        }
        try {
            String[] ipSegments;
            String hostAddress;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)workerId) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(hostAddress = LocalIpAddress.resolveLocalIp())) && (ipSegments = hostAddress.split("\\.")) != null && ipSegments.length == 4) {
                workerId = String.valueOf(Integer.parseInt(ipSegments[0]) + Integer.parseInt(ipSegments[1]) + Integer.parseInt(ipSegments[2]) + Integer.parseInt(ipSegments[3]));
            }
        }
        catch (Exception e) {
            logger.error("error ip generate app.worker.id.", (Throwable)e);
        }
        finally {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)workerId)) {
                logger.warn("use random to generate generate app.worker.id");
                workerId = String.valueOf(random.nextInt(1023));
            }
        }
        return Long.valueOf(workerId);
    }

    public static <T extends BaseEo> String idName(Class<T> aClass) {
        String name = aClass.getName();
        String idColumn = null;
        idColumn = tables.containsKey(name) ? tables.get(name).getIdColumn() : BaseEoUtil.getTableInfo(aClass).getIdColumn();
        if (null == idColumn) {
            throw new BusinessRuntimeException("Undefine POJO @Id");
        }
        return idColumn;
    }

    public static <T extends BaseEo> String tableName(Class<T> aClass) {
        String name = aClass.getName();
        if (tables.containsKey(name)) {
            return tables.get(name).getTableName();
        }
        return BaseEoUtil.getTableInfo(aClass).getTableName();
    }

    private static <T extends BaseEo> TableInfo getTableInfo(Class<T> aClass) {
        TableInfo oldTableInfo;
        String name = aClass.getName();
        Table table = aClass.getAnnotation(Table.class);
        TableInfo tableInfo = new TableInfo();
        if (table == null) {
            throw new BusinessRuntimeException("Undefine POJO @Table, need Annotation(@Table(name))");
        }
        tableInfo.setTableName(table.name());
        for (Field field : BaseEo.class.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class)) continue;
            tableInfo.setIdColumn(field.getName());
            break;
        }
        if (baseColumns == null) {
            try {
                Field[] declaredFields = BaseEo.class.getDeclaredFields();
                baseColumns = new ArrayList<ColumnInfo>(declaredFields.length);
                BaseEoUtil.genColumnInfos(baseColumns, null, null, declaredFields);
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setColumn("id");
                columnInfo.setProperty("id");
                baseColumns.add(columnInfo);
            }
            catch (Exception declaredFields) {
                // empty catch block
            }
        }
        if ((oldTableInfo = tables.putIfAbsent(name, tableInfo)) != null) {
            oldTableInfo.setBaseColumns(baseColumns);
            return oldTableInfo;
        }
        tableInfo.setBaseColumns(baseColumns);
        return tableInfo;
    }

    public static <T extends BaseEo> TableInfo getTableInfoWithColumn(Class<T> aClass) {
        String name = aClass.getName();
        TableInfo tableInfo = null;
        if (tables.containsKey(name) && (tableInfo = tables.get(name)).getColumns() != null) {
            return tableInfo;
        }
        BaseEoUtil.getColumnList(aClass);
        return tables.get(name);
    }

    private static <T extends BaseEo> List<ColumnInfo> getColumnList(Class<T> aClass) {
        String name = aClass.getName();
        TableInfo tableInfo = null;
        if (tables.containsKey(name)) {
            tableInfo = tables.get(name);
            if (tableInfo.getColumns() != null) {
                return tableInfo.getColumns();
            }
        } else {
            tableInfo = BaseEoUtil.getTableInfo(aClass);
        }
        ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
        HashSet<String> columnSet = new HashSet<String>();
        String shardingColumnFiled = null;
        for (Class<T> clazz = aClass; clazz != BaseEo.class; clazz = clazz.getSuperclass()) {
            try {
                ShardingColumn shardingColumn = clazz.getAnnotation(ShardingColumn.class);
                if (shardingColumn != null) {
                    shardingColumnFiled = shardingColumn.name();
                }
                Field[] declaredFields = clazz.getDeclaredFields();
                BaseEoUtil.genColumnInfos(columnList, columnSet, shardingColumnFiled, declaredFields);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tableInfo.setColumns(columnList);
        tables.put(name, tableInfo);
        return columnList;
    }

    private static void genColumnInfos(List<ColumnInfo> columnList, Set<String> columnSet, String shardingColumnFiled, Field[] declaredFields) {
        for (Field field : declaredFields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            String columnName = field.getName();
            if (columnSet != null && columnSet.contains(columnName)) continue;
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setProperty(columnName);
            columnInfo.setPropertyClass(field.getType());
            String tableColumn = !"".equals(column.name()) ? column.name() : CamelToUnderline.camelToUnderline(columnName);
            columnInfo.setColumn(tableColumn);
            if (null != shardingColumnFiled && shardingColumnFiled.equals(tableColumn)) {
                columnInfo.setShardColumn(true);
            }
            columnList.add(columnInfo);
            if (columnSet == null) continue;
            columnSet.add(columnName);
        }
    }

    private static <T extends BaseEo> boolean isWhereNull(T obj, String fieldName) {
        Class<?> aClass = obj.getClass();
        try {
            return BaseEoUtil.fieldValueWhere(aClass, obj, fieldName);
        }
        catch (Exception e) {
            for (Class<?> clazz = aClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    if (clazz != BaseDefEo.class) continue;
                    return BaseEoUtil.fieldValueWhere(clazz, obj, fieldName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private static <T extends BaseEo> boolean fieldValueWhere(Class<?> aClass, T obj, String fieldName) throws Exception {
        for (Class<?> clazz = aClass; clazz != BaseEo.class && clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj) == null || "".equals(field.get(obj));
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        return true;
    }

    private static <T extends BaseEo> boolean isNull(T obj, String fieldName) {
        Class<?> aClass = obj.getClass();
        try {
            return BaseEoUtil.fieldValueBoolean(aClass, obj, fieldName);
        }
        catch (Exception e) {
            for (Class<?> clazz = aClass; clazz != BaseEo.class && clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    if (clazz != BaseDefEo.class) continue;
                    return BaseEoUtil.fieldValueBoolean(clazz, obj, fieldName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private static <T extends BaseEo> boolean fieldValueBoolean(Class<?> aClass, T obj, String fieldName) throws Exception {
        for (Class<?> clazz = aClass; clazz != BaseEo.class && clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj) == null;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        return false;
    }

    public static <T extends BaseEo> String returnSelectColumnsName(Class<T> aClass) {
        StringBuilder sb = new StringBuilder("id,create_time as createTime,create_person as createPerson,update_time as updateTime,update_person as updatePerson,tenant_id as tenantId,instance_id as instanceId,dr as dr");
        for (ColumnInfo map : BaseEoUtil.getColumnList(aClass)) {
            sb.append(',');
            sb.append(map.getColumn());
            sb.append(" as ");
            sb.append(map.getProperty());
        }
        return sb.toString();
    }

    public static <T extends BaseEo> String returnInsertColumnsName(T obj) {
        Class<?> aClass = obj.getClass();
        StringBuilder sb = new StringBuilder("id,");
        for (ColumnInfo map : BaseEoUtil.getColumnList(aClass)) {
            if (BaseEoUtil.isNull(obj, map.getProperty())) continue;
            sb.append(map.getColumn()).append(',');
        }
        sb.append(BaseEoUtil.insertColumn());
        return sb.toString();
    }

    public static <T extends BaseEo> String returnInsertColumnsDef(T obj) {
        Class<?> aClass = obj.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("#{id}").append(',');
        for (ColumnInfo map : BaseEoUtil.getColumnList(aClass)) {
            if (BaseEoUtil.isNull(obj, map.getProperty())) continue;
            sb.append("#{").append(map.getProperty()).append("},");
        }
        sb.append(BaseEoUtil.insertValue(obj, false));
        return sb.toString();
    }

    public static <T extends BaseEo> String returnInsertColumnsNameBatch(Class<T> aClass) {
        StringBuilder sb = new StringBuilder("id,");
        for (ColumnInfo map : BaseEoUtil.getColumnList(aClass)) {
            sb.append(map.getColumn()).append(',');
        }
        sb.append(BaseEoUtil.insertColumn());
        return sb.toString();
    }

    public static <T extends BaseEo> String returnInsertColumnsDefBatch(T obj) {
        Class<?> aClass = obj.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("#'{'objList[{0}].id'}'").append(',');
        for (ColumnInfo map : BaseEoUtil.getColumnList(aClass)) {
            sb.append("#'{'objList[{0}].").append(map.getProperty()).append("'}',");
        }
        sb.append(BaseEoUtil.insertValue(obj, true)).append(")");
        return sb.toString();
    }

    private static String insertColumn() {
        return "create_time,update_time,create_person,tenant_id,instance_id,update_person,dr";
    }

    private static <T extends BaseEo> String insertValue(T obj, Boolean isBatch) {
        String requestUserCode;
        StringBuilder sb = new StringBuilder();
        obj.setCreateTime(new Date());
        obj.setUpdateTime(new Date());
        if (null == obj.getCreatePerson() || "0".equals(obj.getCreatePerson())) {
            requestUserCode = ServiceContext.getContext().getRequestUserCode();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestUserCode)) {
                obj.setCreatePerson("");
            } else {
                obj.setCreatePerson(requestUserCode);
            }
        }
        if (null == obj.getUpdatePerson() || "0".equals(obj.getUpdatePerson())) {
            requestUserCode = ServiceContext.getContext().getRequestUserCode();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestUserCode)) {
                obj.setUpdatePerson("");
            } else {
                obj.setUpdatePerson(requestUserCode);
            }
        }
        if (obj.getTenantId() == null || 0L == obj.getTenantId()) {
            Long tenantId = null == ServiceContext.getContext().getRequestTenantId() ? -1L : ServiceContext.getContext().getRequestTenantId();
            obj.setTenantId(tenantId);
        }
        if (obj.getInstanceId() == null || 0L == obj.getInstanceId()) {
            obj.setInstanceId(null == ServiceContext.getContext().getRequestInstanceId() ? -1L : ServiceContext.getContext().getRequestInstanceId());
        }
        if (isBatch.booleanValue()) {
            sb.append("#'{'objList[{0}].createTime'}'").append(',').append("#'{'objList[{0}].createTime'}'").append(',').append("#'{'objList[{0}].createPerson'}'").append(',').append("#'{'objList[{0}].tenantId'}'").append(',').append("#'{'objList[{0}].instanceId'}'").append(',').append("#'{'objList[{0}].createPerson'}'").append(',').append("#'{'objList[{0}].dr'}'");
        } else {
            sb.append("#{createTime}").append(',').append("#{createTime}").append(',').append("#{createPerson}").append(',').append("#{tenantId}").append(',').append("#{instanceId}").append(',').append("#{createPerson}").append(',').append("#{dr}");
        }
        return sb.toString();
    }

    public static <T extends BaseEo> String returnUpdateSet(T obj) {
        Class<?> aClass = obj.getClass();
        StringBuilder sb = new StringBuilder(BaseEoUtil.updateColumn(obj));
        List<ColumnInfo> columnList = BaseEoUtil.getColumnList(aClass);
        for (ColumnInfo map : columnList) {
            if (map.isShardColumn()) continue;
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(map.getColumn()).append("=#{").append(map.getProperty()).append('}');
        }
        return sb.toString();
    }

    private static <T extends BaseEo> String updateColumn(T obj) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update_time").append("=now()");
        String updatePerson = null;
        updatePerson = null != obj.getUpdatePerson() && !"0".equals(obj.getUpdatePerson()) ? obj.getUpdatePerson() : ServiceContext.getContext().getRequestUserCode();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)updatePerson)) {
            stringBuilder.append(",update_person").append("='").append(updatePerson).append("'");
        }
        return stringBuilder.toString();
    }

    public static <T extends BaseEo> String returnUpdateSetNotNull(T obj) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        List<ColumnInfo> columnList = BaseEoUtil.getColumnList(obj.getClass());
        if (columnList != null && columnList.size() > 0) {
            sb.append(BaseEoUtil.updateColumn(obj));
            i = 1;
        }
        for (ColumnInfo map : columnList) {
            if (BaseEoUtil.isNull(obj, map.getProperty()) || map.isShardColumn()) continue;
            if (i++ != 0) {
                sb.append(',');
            }
            sb.append(map.getColumn()).append("=#{").append(map.getProperty()).append('}');
        }
        return sb.toString();
    }

    public static <T extends BaseEo> String returnWhereColumnNames(T obj, boolean appendArg0) {
        Class<?> aClass = obj.getClass();
        List<ColumnInfo> columnList = BaseEoUtil.getColumnList(aClass);
        HashSet<String> columnsList = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        List<SqlFilter> sqlFilters = obj.getSqlFilters();
        if (sqlFilters != null && sqlFilters.size() > 0) {
            for (SqlFilter filter : sqlFilters) {
                if (filter == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filter.getProperty())) continue;
                String sqlFilterWhere = BaseEoUtil.getSqlFilterWhere(aClass, filter);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sqlFilterWhere)) {
                    if (sb.length() > 0) {
                        sb.append(" and ");
                    }
                    sb.append(sqlFilterWhere);
                }
                columnsList.add(filter.getProperty());
            }
        }
        if (!columnsList.contains("dr")) {
            if (sb.length() > 1) {
                sb.append(" and ");
            }
            if (obj.getDr() == 1) {
                sb.append("dr").append("=1");
            } else {
                sb.append("dr").append("=0");
            }
        }
        for (ColumnInfo map : columnList) {
            if (BaseEoUtil.isWhereNull(obj, map.getProperty()) || columnsList.contains(map.getProperty())) continue;
            if (sb.length() > 1) {
                sb.append(" and ");
            }
            if (appendArg0) {
                sb.append(map.getColumn()).append("=#{arg0.").append(map.getProperty()).append("}");
                continue;
            }
            sb.append(map.getColumn()).append("=#{").append(map.getProperty()).append("}");
        }
        return sb.toString();
    }

    private static <T extends BaseEo> String getSqlFilterWhere(Class<T> aClass, SqlFilter filter) {
        if (filter.getValue() == null) {
            switch (filter.getOperator()) {
                case isNull: 
                case isNotNull: {
                    break;
                }
                default: {
                    return "";
                }
            }
        }
        TableInfo table = BaseEoUtil.getTableInfoWithColumn(aClass);
        StringBuilder sqlWhere = new StringBuilder();
        ColumnInfo columnInfo = table.getColumnInfo(filter.getProperty());
        if (null == columnInfo) {
            return "";
        }
        sqlWhere.append(columnInfo.getColumn());
        switch (filter.getOperator()) {
            case eq: {
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append(" = '").append(value + "'");
                    break;
                }
                sqlWhere.append(" = ").append(filter.getValue());
                break;
            }
            case ne: {
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append(" <> '").append(value + "'");
                    break;
                }
                sqlWhere.append(" <> ").append(filter.getValue());
                break;
            }
            case gt: 
            case lt: {
                if (filter.getOperator() == SqlFilter.Operator.gt) {
                    sqlWhere.append(" > ");
                } else {
                    sqlWhere.append(" < ");
                }
                if (filter.getValue() instanceof Date || filter.getValue() instanceof LocalDate) {
                    sqlWhere.append("'").append(SDF_DATE.format(filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof LocalDateTime) {
                    sqlWhere.append("'").append(SDF_DATETIME.format(filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append("'").append(value).append("'");
                    break;
                }
                sqlWhere.append(filter.getValue());
                break;
            }
            case ge: 
            case le: {
                String time = " 00:00:01'";
                if (filter.getOperator() == SqlFilter.Operator.ge) {
                    sqlWhere.append(" >= ");
                } else {
                    sqlWhere.append(" <= ");
                    time = " 23:59:59'";
                }
                if (filter.getValue() instanceof Date || filter.getValue() instanceof LocalDate) {
                    sqlWhere.append("'").append(SDF_DATE.format(filter.getValue())).append(time);
                    break;
                }
                if (filter.getValue() instanceof LocalDateTime) {
                    sqlWhere.append("'").append(SDF_DATETIME.format(filter.getValue())).append("'");
                    break;
                }
                if (filter.getValue() instanceof String) {
                    String value = String.valueOf(filter.getValue()).replace("'", "\\'");
                    sqlWhere.append("'").append(value).append("'");
                    break;
                }
                sqlWhere.append(filter.getValue());
                break;
            }
            case like: {
                String value = BaseEoUtil.likeValue(filter.getValue().toString());
                sqlWhere.append(" like '").append(value.replaceAll("'", "''")).append("'");
                break;
            }
            case in: {
                String filterValue = BaseEoUtil.processOperatorInValue(columnInfo.getPropertyClass(), filter);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filterValue)) {
                    sqlWhere.append(" in (").append(filterValue).append(")");
                    break;
                }
                return "";
            }
            case isNull: {
                sqlWhere.append(" is null");
                break;
            }
            case isNotNull: {
                sqlWhere.append(" is not null");
            }
        }
        return sqlWhere.toString();
    }

    protected static <T extends BaseEo> String processOperatorInValue(Class<?> fieldClass, SqlFilter filter) {
        if (filter == null || filter.getValue() == null) {
            return null;
        }
        ArrayList processedValues = Lists.newArrayList();
        try {
            if (String.class.equals(fieldClass)) {
                Object filterValue = filter.getValue();
                if (filterValue instanceof String) {
                    String[] splitValues;
                    for (String splitValue : splitValues = ((String)filterValue).split(",")) {
                        if (!splitValue.startsWith("'")) {
                            splitValue = "'" + splitValue;
                        }
                        if (!splitValue.endsWith("'")) {
                            splitValue = splitValue + "'";
                        }
                        processedValues.add(splitValue);
                    }
                } else if (filterValue instanceof Collection) {
                    Collection listFilterValues = (Collection)filterValue;
                    for (Object listValue : listFilterValues) {
                        if (listValue == null) continue;
                        if (listValue instanceof String) {
                            String processValue = (String)listValue;
                            if (!processValue.startsWith("'")) {
                                processValue = "'" + processValue;
                            }
                            if (!processValue.endsWith("'")) {
                                processValue = processValue + "'";
                            }
                            processedValues.add(processValue);
                            continue;
                        }
                        processedValues.add("'" + listValue + "'");
                    }
                } else {
                    processedValues.add("'" + filterValue + "'");
                }
                return Joiner.on((String)",").skipNulls().join((Iterable)processedValues).toString();
            }
            if (filter.getValue() instanceof Collection) {
                return Joiner.on((String)",").skipNulls().join((Iterable)((Collection)filter.getValue())).toString();
            }
            return filter.getValue().toString();
        }
        catch (Exception e) {
            logger.error("sqlfiter\u4f20\u5165\u7684property\u6709\u8bef", (Throwable)e);
            return null;
        }
    }

    private static <T extends BaseEo> String likeValue(String value) {
        String v;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        int start = 0;
        int end = value.length();
        String startValue = "";
        String endValue = "";
        if ("%".equals(value.substring(0, 1))) {
            start = 1;
            startValue = "%";
        }
        if ("%".equals(value.substring(value.length() - 1, value.length()))) {
            end = value.length() - 1;
            endValue = "%";
        }
        if ((v = value.substring(start, end)).indexOf("%") != -1) {
            return startValue + v.replaceAll("%", "[%]") + endValue;
        }
        return value;
    }

    public static <T extends BaseEo> String returnUpdateWhereColumnNames(T obj) {
        List<SqlFilter> sqlFilters = obj.getSqlFilters();
        if (sqlFilters == null || sqlFilters.isEmpty()) {
            return null;
        }
        Class<?> aClass = obj.getClass();
        StringBuilder sb = new StringBuilder();
        boolean hasIdComlumn = false;
        for (SqlFilter filter : sqlFilters) {
            String sqlFilterWhere;
            if (filter == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filter.getProperty())) continue;
            if (filter.getProperty().equals("id")) {
                hasIdComlumn = true;
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(sqlFilterWhere = BaseEoUtil.getSqlFilterWhere(aClass, filter)))) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(sqlFilterWhere);
        }
        if (sb.length() > 0 && !SqlUtil.isSpiteParams(sb.toString().toLowerCase())) {
            logger.error("Malice SQL keyword : {}", (Object)sb.toString());
        }
        if (obj.getId() != null) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("id = #{id}");
        } else if (!(hasIdComlumn || obj.getDr() != null && obj.getDr() != 0)) {
            boolean isExistDr = false;
            for (SqlFilter filter : sqlFilters) {
                if (!filter.getProperty().equalsIgnoreCase("dr")) continue;
                isExistDr = true;
                break;
            }
            if (!isExistDr) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append("dr = 0");
            }
        }
        return sb.toString();
    }

    public static <T extends BaseEo> String resultOrderBy(T obj) {
        ColumnInfo columnInfo;
        String[] strs;
        String orderByDesc = obj.getOrderByDesc();
        String orderBy = obj.getOrderBy();
        List<SqlOrderBy> sqlOrderBys = obj.getSqlOrderBys();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderByDesc) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderBy) && (sqlOrderBys == null || sqlOrderBys.isEmpty())) {
            return "id desc";
        }
        Class<?> aClass = obj.getClass();
        TableInfo table = BaseEoUtil.getTableInfoWithColumn(aClass);
        StringBuilder sb = new StringBuilder();
        if (sqlOrderBys != null && !sqlOrderBys.isEmpty()) {
            for (SqlOrderBy sqlOrderBy : sqlOrderBys) {
                ColumnInfo columnInfo2;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (null != (columnInfo2 = table.getColumnInfo(sqlOrderBy.getProperty()))) {
                    sb.append(columnInfo2.getColumn()).append(sqlOrderBy.getOrder().getSqlSyntax());
                    continue;
                }
                sb.append(sqlOrderBy.getProperty()).append(sqlOrderBy.getOrder().getSqlSyntax());
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderByDesc)) {
            for (String s : strs = orderByDesc.split(",")) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (null != (columnInfo = table.getColumnInfo(s))) {
                    sb.append(columnInfo.getColumn()).append(" desc");
                    continue;
                }
                sb.append(s).append(" desc");
            }
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderBy)) {
            for (String s : strs = orderBy.split(",")) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (null != (columnInfo = table.getColumnInfo(s))) {
                    sb.append(table.getColumnInfo(s).getColumn()).append(" asc");
                    continue;
                }
                sb.append(s).append(" asc");
            }
        }
        if (sb.length() == 0) {
            sb.append("id").append(" desc");
        }
        return sb.toString();
    }

    public static BaseEo build(Class<? extends BaseEo> eoClass) throws Exception {
        try {
            String extClass = StringUtils.delete((String)eoClass.getName(), (String)"Eo") + "ExtEo";
            return (BaseEo)Class.forName(extClass).newInstance();
        }
        catch (ClassNotFoundException ex) {
            return eoClass.newInstance();
        }
    }

    public static BaseEo build(Class<? extends BaseEo> eoClass, Map<String, Object> extFields) throws Exception {
        try {
            String extClass = StringUtils.delete((String)eoClass.getName(), (String)"Eo") + "ExtEo";
            BaseEo eo = (BaseEo)Class.forName(extClass).newInstance();
            if (null != extFields) {
                BeanUtils.populate((Object)eo, extFields);
            }
            return eo;
        }
        catch (ClassNotFoundException ex) {
            return eoClass.newInstance();
        }
    }

    public static void setWorkerId(String workerId) {
        BaseEoUtil.workerId = workerId;
    }

    public static void main(String[] args) {
        TableInfo table = BaseEoUtil.getTableInfo(BaseEo.class);
        System.out.println(table.getBaseColumns());
    }

    static {
        SDF_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SDF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    }
}

