/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.http.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class JsLongFastJsonHttpMessageConverter
extends FastJsonHttpMessageConverter {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public JsLongFastJsonHttpMessageConverter() {
        this.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)));
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        ValueFilter filter = new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value != null && value instanceof Long && (Long)value > Integer.MAX_VALUE) {
                    return value.toString();
                }
                if (value != null && value instanceof List) {
                    ArrayList<String> parseValue = new ArrayList<String>();
                    for (Object item : (List)value) {
                        if (item instanceof Long && (Long)item > Integer.MAX_VALUE) {
                            parseValue.add(item.toString());
                            continue;
                        }
                        parseValue.add((String)item);
                    }
                    return parseValue;
                }
                return value;
            }
        };
        String text = JSON.toJSONString((Object)obj, (SerializeFilter)filter, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
        byte[] bytes = text.getBytes(UTF8);
        OutputStream out = outputMessage.getBody();
        out.write(bytes);
    }
}

