/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.filter;

import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ExtendedServletRequestDataBinder;

public class EmptyStringToNullRequestDataBinder
extends ExtendedServletRequestDataBinder {
    private static final Logger logger = LoggerFactory.getLogger(EmptyStringToNullRequestDataBinder.class);

    public EmptyStringToNullRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        for (PropertyValue propertyValue : mpvs.getPropertyValueList()) {
            if (propertyValue.getValue() == null) continue;
            logger.debug("1\u3001name={},value={}", (Object)propertyValue.getName(), propertyValue.getValue());
            if (propertyValue.getValue().equals("")) {
                propertyValue.setConvertedValue(null);
                continue;
            }
            logger.debug("2\u3001name={},value={}", (Object)propertyValue.getName(), propertyValue.getValue());
            if (StringUtils.isNumeric((CharSequence)String.valueOf(propertyValue.getValue()))) continue;
            String value = StringUtils.trimToNull((String)String.valueOf(propertyValue.getValue()));
            if (value == null) {
                propertyValue.setConvertedValue(null);
            } else {
                if (value.equals(propertyValue.getValue())) continue;
                propertyValue.setConvertedValue((Object)value);
            }
            logger.debug("3\u3001name={},value={}", (Object)propertyValue.getName(), propertyValue.getValue());
        }
        this.filterRequestAttributes(mpvs, request);
    }

    private void filterRequestAttributes(MutablePropertyValues mpvs, ServletRequest request) {
        String attr = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        Map uriVars = (Map)request.getAttribute(attr);
        if (uriVars != null) {
            for (Map.Entry entry : uriVars.entrySet()) {
                String value;
                if (mpvs.contains((String)entry.getKey())) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Skipping URI variable '" + (String)entry.getKey() + "' since the request contains a bind value with the same name.");
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) || StringUtils.isEmpty((CharSequence)(value = ((String)entry.getValue()).trim()))) continue;
                logger.debug("name={},value={}", entry.getKey(), (Object)value);
                mpvs.addPropertyValue((String)entry.getKey(), (Object)value);
            }
        }
    }
}

