/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.lang.BusinessRuntimeException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64 {
    private static final Logger logger = LoggerFactory.getLogger(Base64.class);

    public static String encodeString(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return new String(encoder.encode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String encodeString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return new String(encoder.encode(bytes), StandardCharsets.UTF_8);
    }

    public static String encodeString(String value, Charset charset) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return new String(encoder.encode(value.getBytes(charset)), charset);
    }

    public static String encodeString(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return new String(encoder.encode(bytes), charset);
    }

    @Deprecated
    public static String encodeString(String value, String charset) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        try {
            return new String(encoder.encode(value.getBytes(charset)), charset);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5bf9\u5b57\u7b26\u4e32\u6307\u5b9a\u7f16\u7801\u52a0\u5bc6\u5931\u8d25\uff01", (Throwable)e);
            throw new BusinessRuntimeException("\u5bf9\u5b57\u7b26\u4e32\u6307\u5b9a\u7f16\u7801\u52a0\u5bc6\u5931\u8d25\uff01\u5b57\u7b26\u96c6=" + charset);
        }
    }

    public static String decodeString(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Base64.Decoder decoder = java.util.Base64.getDecoder();
        return new String(decoder.decode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String decodeString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Base64.Decoder decoder = java.util.Base64.getDecoder();
        return new String(decoder.decode(bytes), StandardCharsets.UTF_8);
    }

    public static String decodeString(String value, Charset charset) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Base64.Decoder decoder = java.util.Base64.getDecoder();
        return new String(decoder.decode(value.getBytes(charset)), charset);
    }

    public static String decodeString(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        Base64.Decoder decoder = java.util.Base64.getDecoder();
        return new String(decoder.decode(bytes), charset);
    }
}

