/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.net.LocalIpAddress;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenrator {
    private static final IdGenrator INASTNCE = new IdGenrator();
    private static final Logger logger = LoggerFactory.getLogger(IdGenrator.class);
    private static final long epoch = 1504842098117L;
    private static final long workerIdBits = 10L;
    private static final long tenantIdBits = 3L;
    private static final long maxWorkerId = 1023L;
    private static final long maxTenantId = 7L;
    private static long sequence = 0L;
    private static final long sequenceBits = 10L;
    private static final Random random = new Random();
    private static final long timestampBits = 40L;
    private static final long workerIdShift = 10L;
    private static final long timestampShift = 20L;
    private static final long tenantIdShift = 60L;
    private static final long sequenceMask = 1023L;
    private static long lastTimestamp = -1L;
    private static String workerId = null;

    public static IdGenrator getInstance() {
        return INASTNCE;
    }

    public static Long getWorkerId() {
        if (StringUtils.isNotEmpty((CharSequence)workerId)) {
            return Long.valueOf(workerId);
        }
        try {
            String[] ipSegments;
            String hostAddress;
            if (StringUtils.isEmpty((CharSequence)workerId) && StringUtils.isNotBlank((CharSequence)(hostAddress = LocalIpAddress.resolveLocalIp())) && (ipSegments = hostAddress.split("\\.")).length == 4) {
                workerId = String.valueOf(Integer.parseInt(ipSegments[0]) + Integer.parseInt(ipSegments[1]) + Integer.parseInt(ipSegments[2]) + Integer.parseInt(ipSegments[3]));
            }
        }
        catch (Exception e) {
            logger.error("error ip generate app.worker.id.", (Throwable)e);
        }
        finally {
            if (StringUtils.isEmpty((CharSequence)workerId)) {
                logger.warn("use random to generate generate app.worker.id");
                workerId = String.valueOf(random.nextInt(1023));
            }
        }
        return Long.valueOf(workerId);
    }

    public static long getDistributedId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId(workerId, tenantCode);
    }

    public static synchronized long nextId(long workerId, long tenantCode) {
        if (workerId > 1023L || workerId < 0L) {
            throw new BusinessRuntimeException(String.format("worker Id:{%d} can't be greater than %d or less than 0", workerId, 1023L));
        }
        if (tenantCode > 7L || tenantCode < 0L) {
            throw new BusinessRuntimeException(String.format("tenant Id:{%d} can't be greater than %d or less than 0", tenantCode, 7L));
        }
        long timestamp = System.currentTimeMillis();
        if ((sequence = sequence + 1L & 0x3FFL) == 0L) {
            timestamp = IdGenrator.nextMillis(lastTimestamp);
        }
        if (timestamp < lastTimestamp) {
            logger.error(String.format("clock moved backwards.Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
            throw new BusinessRuntimeException(String.format("clock moved backwards.Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        lastTimestamp = timestamp;
        return tenantCode << 60 | timestamp - 1504842098117L << 20 | workerId << 10 | sequence;
    }

    private static long nextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public static Date getDate(long id) {
        long headTenant = 0x7FFFFFFFFFFFFFFL;
        long idWithTenant = id & headTenant;
        long v1 = idWithTenant >>> 20;
        return new Date(1504842098117L + v1);
    }

    public static long getMachineId(long id) {
        long head = 524287L;
        long id2 = id & head;
        long v1 = id2 >>> 10;
        return v1;
    }
}

