/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.app;

public enum DeployEnv {
    DEPLOY_ENV_EDAS_HSF("edas_hsf"),
    DEPLOY_ENV_EDAS_SPRINGCLOUD("edas_springcloud"),
    DEPLOY_ENV_SPRINGCLOUD("springcloud");

    public static final String DEPLOY = "dtyunxi.deploy";
    private String env;

    private DeployEnv(String env) {
        this.env = env;
    }

    public String getEnv() {
        return this.env;
    }

    public static DeployEnv getDeployEnv() {
        return DeployEnv.getDeployEnvEnum(System.getProperty(DEPLOY));
    }

    public static boolean isEdas() {
        DeployEnv deployEnv = DeployEnv.getDeployEnv();
        return DEPLOY_ENV_EDAS_HSF == deployEnv || DEPLOY_ENV_EDAS_SPRINGCLOUD == deployEnv;
    }

    public static boolean isEdasHsf() {
        return DEPLOY_ENV_EDAS_HSF == DeployEnv.getDeployEnv();
    }

    public static boolean isSpringCloud() {
        DeployEnv deployEnv = DeployEnv.getDeployEnv();
        return DEPLOY_ENV_EDAS_SPRINGCLOUD == deployEnv || DEPLOY_ENV_SPRINGCLOUD == deployEnv;
    }

    public static boolean isSpringCloudPure() {
        return DEPLOY_ENV_EDAS_SPRINGCLOUD == DeployEnv.getDeployEnv();
    }

    private static DeployEnv getDeployEnvEnum(String strDeploy) {
        if (DEPLOY_ENV_EDAS_HSF.getEnv().equals(strDeploy)) {
            return DEPLOY_ENV_EDAS_HSF;
        }
        if (DEPLOY_ENV_EDAS_SPRINGCLOUD.getEnv().equals(strDeploy)) {
            return DEPLOY_ENV_EDAS_SPRINGCLOUD;
        }
        if (DEPLOY_ENV_SPRINGCLOUD.getEnv().equals(strDeploy)) {
            return DEPLOY_ENV_SPRINGCLOUD;
        }
        return DEPLOY_ENV_EDAS_SPRINGCLOUD;
    }
}

