/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static Map<String, Map<String, Method>> methodMap = new HashMap<String, Map<String, Method>>();

    public static Object invokeExistGetter(Object obj, String propertyName) {
        if (ReflectionUtils.isExistGetter(obj, propertyName)) {
            return ReflectionUtils.invokeGetterMethod(obj, propertyName);
        }
        return null;
    }

    public static void invokeExistSetter(Object obj, String propertyName, Object value) {
        if (ReflectionUtils.isExistSetter(obj, propertyName)) {
            ReflectionUtils.invokeSetterMethod(obj, propertyName, value);
        }
    }

    public static boolean isExistGetter(Object obj, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.isExistMethod(obj, getterMethodName);
    }

    public static boolean isExistSetter(Object obj, String propertyName) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.isExistMethod(obj, setterMethodName);
    }

    public static boolean isExistMethod(Object obj, String methodName) {
        Map<String, Method> map = methodMap.get(obj.getClass().getName());
        if (map != null && map.get(methodName) != null) {
            return true;
        }
        map = new HashMap<String, Method>();
        methodMap.put(obj.getClass().getName(), map);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                map.put(method.getName(), method);
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtils.getAccessibleMethodByName(obj, methodName);
        if (method == null) {
            throw new IllegalArgumentException("\u5728 [" + obj + "]\u7c7b\u91cc\u9762\u627e\u4e0d\u5230\u65b9\u6cd5 [" + methodName + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        Validate.notNull((Object)obj, (String)"\u7528\u4e8e\u53cd\u5c04\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3aNULL", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)methodName, (String)"\u53cd\u5c04\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtils.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static Object invokeGetterMethod(Object obj, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value) {
        ReflectionUtils.invokeSetterMethod(obj, propertyName, value, null);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value, Class<?> propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        ReflectionUtils.invokeMethod(obj, setterMethodName, new Class[]{type}, new Object[]{value});
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        Object result = null;
        if (field == null) {
            return result;
        }
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        if (obj == null) {
            logger.error("ReflectionUtil.getAccessibleField(final Object obj, final String fieldName)\u7684obj\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NullPointerException("object\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            logger.error("ReflectionUtil.getAccessibleField(final Object obj, final String fieldName)\u7684fieldName\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NullPointerException("fieldName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtils.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        if (obj == null) {
            logger.error("ReflectionUtil.getAccessibleField(final Object obj, final String fieldName)\u7684obj\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            throw new NullPointerException("object\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Method method = superClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static <T> Class<T> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionUtils.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }
}

