/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.springboot.beans;

import com.dtyunxi.springboot.beans.SystemConfig;
import com.dtyunxi.util.ReflectionUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.PriorityOrdered;

public class PlaceHolderBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    private static final Logger logger = LoggerFactory.getLogger(PlaceHolderBeanDefinitionRegistryPostProcessor.class);
    private static final String HSF_CONSUMER_UTIL_CLASS_NAME = "com.taobao.hsf.app.spring.util.HSFSpringConsumerBean";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Map beanDefinitionMap = (Map)ReflectionUtils.getFieldValue(beanDefinitionRegistry, "beanDefinitionMap");
        for (Map.Entry entry : beanDefinitionMap.entrySet()) {
            BeanDefinition beanDefinition = (BeanDefinition)entry.getValue();
            if (!HSF_CONSUMER_UTIL_CLASS_NAME.equalsIgnoreCase(beanDefinition.getBeanClassName()) || !(beanDefinition instanceof GenericBeanDefinition)) continue;
            AbstractBeanDefinition newBeanDefinition = ((GenericBeanDefinition)beanDefinition).cloneBeanDefinition();
            newBeanDefinition.getPropertyValues().getPropertyValueList().clear();
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            for (PropertyValue propertyValue : propertyValues.getPropertyValueList()) {
                if (propertyValue.getValue() != null) {
                    propertyValue = this.replacePropertyValue(propertyValue);
                }
                newBeanDefinition.getPropertyValues().getPropertyValueList().add(propertyValue);
            }
            beanDefinitionRegistry.removeBeanDefinition((String)entry.getKey());
            beanDefinitionRegistry.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)newBeanDefinition);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public int getOrder() {
        SystemConfig.loadSystemConfig();
        return 0;
    }

    private PropertyValue replacePropertyValue(PropertyValue propertyValue) {
        propertyValue = new PropertyValue(propertyValue, this.replaceConfigValue(propertyValue.getValue()));
        return propertyValue;
    }

    private Object replaceConfigValue(Object value) {
        Object replacedObj = null;
        if (value != null) {
            if (value instanceof TypedStringValue) {
                value = this.replaceString(((TypedStringValue)value).getValue());
                replacedObj = new TypedStringValue(value.toString());
            } else {
                replacedObj = value = this.replaceString(value.toString());
            }
        }
        return replacedObj;
    }

    private String replaceString(String value) {
        Pattern pattern = Pattern.compile("\\$\\{.+\\}");
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            value = this.parserConfigValue(value.toString());
        }
        return value;
    }

    private String parserConfigValue(String value) {
        value = value.trim().substring(2, value.length() - 1);
        return SystemConfig.getStringValue(value);
    }
}

