/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.CaseFormat;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.ClassUtils;

public class ObjectConvertor {
    private static final Logger logger = LoggerFactory.getLogger(ObjectConvertor.class);
    private static final DefaultConversionService conversionService = new DefaultConversionService();

    public static <T> PageInfo<T> convertPageInfo(List<?> pageInfo, Class<T> targetClazz) {
        if (pageInfo instanceof PageInfo) {
            PageInfo realPageInfo = (PageInfo)pageInfo;
            return ObjectConvertor.convertPageInfo(realPageInfo, targetClazz, "");
        }
        throw new RuntimeException("\u5e26\u8f6c\u6362\u7684\u7c7b\u5b9e\u4f8b\u4e0d\u662fcom.github.pagehelper.PageInfo");
    }

    public static <T> PageInfo<T> convertPageInfo(PageInfo<?> pageInfo, Class<T> targetClazz) {
        return ObjectConvertor.convertPageInfo(pageInfo, targetClazz, "");
    }

    public static <T> PageInfo<T> convertPageInfo(PageInfo<?> pageInfo, Class<T> targetClazz, String ... ignoreProperties) {
        if (null == pageInfo) {
            return null;
        }
        List<T> list = ObjectConvertor.convertObjects(pageInfo.getList(), targetClazz, ignoreProperties);
        PageInfo newPageInfo = ObjectConvertor.convert(pageInfo, PageInfo.class);
        newPageInfo.setList(list);
        return newPageInfo;
    }

    public static <T> T convert(Object object, Class<T> targetClazz, String ... ignoreProperties) {
        if (null == object) {
            return null;
        }
        T target = null;
        try {
            target = targetClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (object instanceof BaseEo && target instanceof BaseVo) {
            BaseVo baseVo = (BaseVo)target;
            BaseEo baseEo = (BaseEo)object;
            ObjectConvertor.eo2Dto(baseEo, baseVo, ignoreProperties);
        } else if (object instanceof BaseVo && target instanceof BaseEo) {
            BaseVo baseVo = (BaseVo)object;
            BaseEo baseEo = (BaseEo)target;
            ObjectConvertor.dto2Eo(baseVo, baseEo, ignoreProperties);
        } else {
            BeanUtils.copyProperties((Object)object, target, (String[])ignoreProperties);
        }
        return target;
    }

    public static <T> T convert(Object object, Class<T> targetClazz) {
        return ObjectConvertor.convert(object, targetClazz, "");
    }

    public static <T> List<T> convertObjects(List<?> objects, Class<T> targetClazz, String ... ignoreProperties) {
        ArrayList targetObjects = new ArrayList();
        objects.stream().forEach(object -> {
            Object targetObject = ObjectConvertor.convert(object, targetClazz, ignoreProperties);
            targetObjects.add(targetObject);
        });
        return targetObjects;
    }

    public static <T> List<T> convertObjects(List<Object> objects, Class<T> targetClazz) {
        return ObjectConvertor.convertObjects(objects, targetClazz, "");
    }

    private static <D extends BaseVo> D eo2DtoWithReturn(BaseEo baseEo, D baseVo, String ... ignoreProperties) {
        if (null == baseEo) {
            return null;
        }
        try {
            if (ObjectConvertor.isExtEo(baseEo)) {
                BeanUtils.copyProperties(baseVo, (Object)baseEo, (String[])ignoreProperties);
                baseVo = ObjectConvertor.eo2DtoCopyExtFields(baseEo, baseVo);
            } else {
                BeanUtils.copyProperties(baseVo, (Object)baseEo, (String[])ignoreProperties);
                if (baseEo.getClass().getSuperclass().getSimpleName().contains("Std") && baseEo.getClass().getSuperclass().getSimpleName().contains("Eo")) {
                    baseVo = ObjectConvertor.eo2DtoCopyExtFields(baseEo, baseVo);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return baseVo;
    }

    private static <D extends BaseVo> D eo2DtoCopyExtFields(BaseEo baseEo, D baseVo) throws IllegalAccessException {
        Field[] fields;
        if (null == baseEo || null == baseVo) {
            return baseVo;
        }
        HashMap<String, Object> extMap = baseVo.getExtFields();
        if (null == extMap) {
            extMap = new HashMap<String, Object>();
            baseVo.setExtFields(extMap);
        }
        for (Field field : fields = baseEo.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            extMap.put(field.getName(), field.get(baseEo));
        }
        return baseVo;
    }

    private static void eo2Dto(BaseEo baseEo, BaseVo baseVo) {
        ObjectConvertor.eo2DtoWithReturn(baseEo, baseVo, new String[0]);
    }

    private static void eo2Dto(BaseEo baseEo, BaseVo baseVo, String ... ignoreProperties) {
        ObjectConvertor.eo2DtoWithReturn(baseEo, baseVo, ignoreProperties);
    }

    private static List<SqlFilter> getSqlFilterWithIn(BaseVo baseVo) {
        Class<?> type = baseVo.getClass();
        ArrayList<SqlFilter> result = new ArrayList<SqlFilter>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                boolean isGetterMethod;
                String attrName = pd.getName();
                boolean bl = isGetterMethod = pd.getReadMethod() != null && !"class".equals(attrName);
                if (!isGetterMethod) continue;
                String filedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, pd.getName());
                Object value = pd.getReadMethod().invoke((Object)baseVo, new Object[0]);
                if (value == null || !Collection.class.isAssignableFrom(pd.getPropertyType())) continue;
                SqlFilter sqlFilter = new SqlFilter(filedName, SqlFilter.Operator.in, value);
                result.add(sqlFilter);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406dto\u65f6\u5931\u8d25: class={}", type);
            throw new RuntimeException(e);
        }
        return result.isEmpty() ? null : result;
    }

    private static <E extends BaseEo> E dto2Eo(BaseVo baseVo, E baseEo, boolean fillSqlFilter, String ... ignoreProperties) {
        List<SqlFilter> listFilters;
        if (baseVo == null) {
            return null;
        }
        BeanUtils.copyProperties(baseEo, (Object)baseVo, (String[])ignoreProperties);
        Map extFields = baseVo.getExtFields();
        if (null != extFields && extFields.size() > 0) {
            Class<?> aClass = baseEo.getClass();
            extFields.forEach((k, v) -> {
                if (k != null && v != null) {
                    PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)aClass, (String)k);
                    if (propertyDescriptor != null) {
                        Method writeMethod = propertyDescriptor.getWriteMethod();
                        try {
                            Class<?> targetType = writeMethod.getParameterTypes()[0];
                            if (!ClassUtils.isAssignable(targetType, v.getClass())) {
                                v = conversionService.convert(v, targetType);
                            }
                            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                                writeMethod.setAccessible(true);
                            }
                            writeMethod.invoke((Object)baseEo, v);
                        }
                        catch (Throwable ex) {
                            throw new FatalBeanException("Could not copy property '" + k + "' from source to target", ex);
                        }
                    } else {
                        propertyDescriptor = BeanUtils.getPropertyDescriptor((Class)aClass, (String)"extFields");
                        if (null != propertyDescriptor) {
                            baseEo.getExtFields().put((String)k, v);
                        }
                    }
                }
            });
        }
        if (fillSqlFilter && (listFilters = ObjectConvertor.getSqlFilterWithIn(baseVo)) != null) {
            if (baseEo.getSqlFilters() == null) {
                baseEo.setSqlFilters(listFilters);
            } else {
                baseEo.getSqlFilters().addAll(listFilters);
            }
        }
        return baseEo;
    }

    private static <E extends BaseEo> E dto2EoWithSqlFilter(BaseVo baseVo, E baseEo) {
        return ObjectConvertor.dto2Eo(baseVo, baseEo, true, new String[0]);
    }

    private static void dto2Eo(BaseVo baseVo, BaseEo baseEo) {
        ObjectConvertor.dto2Eo(baseVo, baseEo, false, new String[0]);
    }

    private static void dto2Eo(BaseVo baseVo, BaseEo baseEo, String ... ignoreProperties) {
        ObjectConvertor.dto2Eo(baseVo, baseEo, false, ignoreProperties);
    }

    private static <T extends BaseVo> void eoList2DtoList(Collection<? extends BaseEo> eos, Collection<T> dtos, Class<T> targetClazz) {
        if (!CollectionUtils.isEmpty(eos)) {
            for (BaseEo baseEo : eos) {
                BaseVo newObj = null;
                try {
                    newObj = (BaseVo)targetClazz.newInstance();
                }
                catch (Exception var7) {
                    logger.error("copyCollection newInstance Exception:", (Throwable)var7);
                }
                ObjectConvertor.eo2Dto(baseEo, newObj);
                dtos.add(newObj);
            }
        }
    }

    private static <T extends BaseEo> void dtoList2EoList(Collection<? extends BaseVo> dtos, Collection<T> eos, Class<T> targetClazz) {
        if (!CollectionUtils.isEmpty(dtos)) {
            for (BaseVo baseVo : dtos) {
                BaseEo newObj = null;
                try {
                    newObj = (BaseEo)targetClazz.newInstance();
                }
                catch (Exception var7) {
                    logger.error("copyCollection newInstance Exception:", (Throwable)var7);
                }
                ObjectConvertor.dto2Eo(baseVo, newObj);
                eos.add(newObj);
            }
        }
    }

    private static boolean isExtEo(BaseEo baseEo) {
        String eoClassName = baseEo.getClass().getSimpleName();
        return eoClassName.contains("ExtEo");
    }

    private static void vo2Dto(BaseVo baseVo, BaseVo baseDto) {
        ObjectConvertor.vo2Dto(baseVo, baseDto, new String[0]);
    }

    private static void vo2Dto(BaseVo baseVo, BaseVo baseDto, String ... ignoreProperties) {
        if (null == baseVo) {
            return;
        }
        try {
            BeanUtils.copyProperties((Object)baseDto, (Object)baseVo, (String[])ignoreProperties);
            Field[] fields = baseVo.getClass().getDeclaredFields();
            HashMap<String, Object> extMap = new HashMap<String, Object>();
            for (Field field : fields) {
                if (!ObjectConvertor.hasAttributeAddAnnotation(field)) continue;
                field.setAccessible(true);
                extMap.put(field.getName(), field.get(baseVo));
            }
            baseDto.getExtFields().putAll(extMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasAttributeAddAnnotation(Field field) {
        Annotation[] annotations = field.getAnnotations();
        if (annotations == null || annotations.length < 1) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.getClass().getName().equals("com.dtyunxi.cube.framework.annotation.AttributeAdd")) continue;
            return true;
        }
        return false;
    }

    static {
        conversionService.addConverter(String.class, Date.class, value -> {
            value = value.trim();
            int len = value.length();
            boolean hasDash = value.contains("-");
            boolean hasSlash = value.contains("/");
            boolean hasSpace = value.contains(" ");
            boolean hasColon = value.contains(":");
            boolean hasT = value.contains("T");
            boolean isTight = !hasSlash && !hasDash && !hasSpace && !hasColon && hasT;
            Date result = null;
            try {
                if (isTight && len == 8) {
                    result = FastDateFormat.getInstance((String)"yyyyMMdd").parse(value);
                } else if (isTight && len == 14) {
                    result = FastDateFormat.getInstance((String)"yyyyMMddHHmmss").parse(value);
                } else if (!isTight && len >= 8 && len <= 10 && hasDash) {
                    result = FastDateFormat.getInstance((String)"yyyy-MM-dd").parse(value);
                } else if (!isTight && len >= 8 && len <= 10 && hasSlash) {
                    result = FastDateFormat.getInstance((String)"yyyy/MM/dd").parse(value);
                } else if (!isTight && len > 10 && len <= 19 && hasDash && hasColon) {
                    result = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").parse(value);
                } else if (!isTight && len > 10 && len <= 19 && hasSlash && hasColon) {
                    result = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss").parse(value);
                }
            }
            catch (ParseException e) {
                throw new BizException("\u5c06" + value + "\u8f6c\u5316\u4e3aDate\u7c7b\u578b\u51fa\u9519:" + e.getMessage());
            }
            return result;
        });
    }
}

