/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.util.HexUtil;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignRequestUtil {
    private static String CHARSET_NAME = "UTF-8";
    private static String SIGN_METHOD_MD5 = "md5";
    private static String SIGN_METHOD_HMAC = "hmac";

    public static String signTopRequest(Map<String, String> params, String secret, String signMethod) {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if (SIGN_METHOD_MD5.equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (value == null) continue;
            query.append((String)key).append(value);
        }
        if (SIGN_METHOD_HMAC.equals(signMethod)) {
            bytes = SignRequestUtil.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = SignRequestUtil.encryptMD5(query.toString());
        }
        return HexUtil.bytes2Hex(bytes);
    }

    public static byte[] encryptHMAC(String data, String secret) {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET_NAME), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes(CHARSET_NAME));
        }
        catch (GeneralSecurityException gse) {
            gse.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static byte[] encryptMD5(String data) {
        if (data == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(data.getBytes(CHARSET_NAME));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

