/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.config;

import com.dtyunxi.annotation.SPI;
import com.dtyunxi.spi.ExtensionLoader;
import com.dtyunxi.util.ClassScannerUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExtendLoaderProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(ExtendLoaderProcessor.class);

    public List<String> getScanPackage() {
        return Lists.newArrayList((Object[])new String[]{"com.dtyunxi"});
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        logger.info("SPI processor processing... ");
        HashSet spiInterfaces = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(this.getScanPackage())) {
            for (String pack : this.getScanPackage()) {
                spiInterfaces.addAll(ClassScannerUtil.getAnnotationClasses(pack, SPI.class));
            }
        } else {
            spiInterfaces.addAll(ClassScannerUtil.getAnnotationClasses("com.dtyunxi", SPI.class));
        }
        String[] beanNames = beanDefinitionRegistry.getBeanDefinitionNames();
        HashMap<String, String> beanClassNameMap = new HashMap<String, String>();
        if (beanNames != null && beanNames.length > 0) {
            for (String string : beanNames) {
                BeanDefinition definition = beanDefinitionRegistry.getBeanDefinition(string);
                beanClassNameMap.put(definition.getBeanClassName(), string);
            }
        }
        if (spiInterfaces != null && spiInterfaces.size() > 0) {
            for (Class clazz : spiInterfaces) {
                HashSet superClassList = Sets.newHashSet();
                if (CollectionUtils.isNotEmpty(this.getScanPackage())) {
                    for (String pack : this.getScanPackage()) {
                        superClassList.addAll(ClassScannerUtil.getAllSubClassOfInteface(pack, clazz));
                    }
                } else {
                    superClassList.addAll(ClassScannerUtil.getAllSubClassOfInteface("com.dtyunxi", clazz));
                }
                ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(clazz);
                Class<?> extensionClass = extensionLoader.getExtensionClass();
                if (CollectionUtils.isEmpty((Collection)superClassList)) {
                    throw new RuntimeException("SPI\u6807\u51c6\u7684\u63a5\u53e3\u5fc5\u987b\u81f3\u5c11\u5fc5\u987b\u6709\u4e00\u4e2a\u5b9e\u73b0\u7c7b");
                }
                Map<String, Class<?>> classMap = extensionLoader.getClasses();
                if (classMap != null && classMap.size() > 0) {
                    superClassList.addAll(classMap.values());
                }
                logger.info("\u5f53\u524d\u6fc0\u6d3b\u7684\u6269\u5c55\u7c7b:{},\u626b\u63cf\u51fa\u7684\u6240\u6709\u5b9e\u73b0\u7c7b:{}", extensionClass, (Object)superClassList);
                for (Class superClazz : superClassList) {
                    if (extensionClass != null && extensionClass.equals(superClazz)) continue;
                    logger.warn("@SPI\u63a5\u53e3 {} \u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b class {} \u4e0d\u662f\u6fc0\u6d3b\u7684\u5b9e\u73b0\u7c7b,SpringContext\u5c06\u79fb\u9664\u5bf9\u5e94\u7684bean", (Object)clazz, (Object)superClazz);
                    this.removeBean(beanDefinitionRegistry, beanClassNameMap, superClazz);
                }
            }
        } else {
            logger.info("\u65e0@SPI\u63a5\u53e3");
        }
    }

    private void removeBean(BeanDefinitionRegistry beanDefinitionRegistry, Map<String, String> beanClassNameMap, Class<?> clazz) {
        String beanName = beanClassNameMap.get(clazz.getName());
        if (StringUtils.isNotBlank((CharSequence)beanName)) {
            try {
                beanClassNameMap.put(clazz.getName(), null);
                beanDefinitionRegistry.removeBeanDefinition(beanName);
            }
            catch (Exception e) {
                logger.error("\u79fb\u9664\u6307\u5b9abean\u65f6\u5f02\u5e38,beanName:{},class:{}", new Object[]{beanName, clazz.getName(), e});
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }
}

