/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yes.rpc;

import com.dtyunxi.app.ServiceContext;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroServiceContextServletFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MicroServiceContextServletFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.beforeFilter(request);
        try {
            chain.doFilter(request, response);
        }
        catch (ServletException se) {
            logger.error(se.getMessage(), (Throwable)se);
            ((HttpServletResponse)response).setStatus(500);
            throw se;
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            ((HttpServletResponse)response).setStatus(500);
            throw ioe;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            ((HttpServletResponse)response).setStatus(500);
            throw new ServletException(t.getMessage(), t);
        }
    }

    void beforeFilter(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            MicroServiceContextServletFilter.setAttachmentFromHeader((HttpServletRequest)request);
        }
        MicroServiceContextServletFilter.setAttachmentFromParameter(request);
    }

    public static void setAttachmentFromHeader(HttpServletRequest httpServletRequest) {
        Enumeration enumHeaders = httpServletRequest.getHeaderNames();
        while (enumHeaders.hasMoreElements()) {
            String header = (String)enumHeaders.nextElement();
            if (!header.startsWith("x-dtyunxi-context-")) continue;
            String key = header.substring("x-dtyunxi-context-".length());
            String attachement = httpServletRequest.getHeader(header);
            ServiceContext.getContext().setAttachment(key, attachement);
        }
    }

    public static void setAttachmentFromParameter(ServletRequest request) {
        String updatePerson;
        String appId;
        String reqId;
        if (ServiceContext.getContext().getAttachment("yes.req.requestId") == null && (reqId = request.getParameter("reqId")) != null) {
            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        }
        if (ServiceContext.getContext().getAttachment("dtyunxi.appId") == null && (appId = request.getParameter("appId")) != null) {
            ServiceContext.getContext().setAttachment("dtyunxi.appId", appId);
        }
        if (ServiceContext.getContext().getAttachment("yes.req.tenantId") == null) {
            String tenantId = request.getParameter("tenantId");
            if (tenantId != null) {
                ServiceContext.getContext().setAttachment("yes.req.tenantId", tenantId);
            } else {
                ServiceContext.getContext().setAttachment("yes.req.tenantId", "0");
            }
        }
        if (ServiceContext.getContext().getAttachment("yes.req.userCode") == null && (updatePerson = request.getParameter("update_person")) != null) {
            ServiceContext.getContext().setAttachment("yes.req.userCode", updatePerson);
        }
    }

    public void destroy() {
    }
}

