/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.Des3Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CipherTextUtil {
    private static final Logger logger = LoggerFactory.getLogger(CipherTextUtil.class);
    private static final String DEFAULT_KEY = "DtYunXi711##$$!!20171103";
    private static final String CIPHER_FORMAT = "##%s##";
    private static final Pattern PATTERN = Pattern.compile("##([a-z|0-9]+)##");

    public static String encode(String key, String data) {
        logger.debug("\u52a0\u5bc6\u65b9\u6cd5! key={},data={}", (Object)key, (Object)data);
        try {
            if (StringUtils.isBlank((CharSequence)data)) {
                return data;
            }
            if (StringUtils.isBlank((CharSequence)key)) {
                return String.format(CIPHER_FORMAT, Des3Utils.des3EncodeCBCString(DEFAULT_KEY, data));
            }
            if (key.length() < 24) {
                throw new BusinessRuntimeException("\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e24\u4e2a(\u82f1\u6587/\u6570\u5b57/\u7279\u6b8a\u5b57\u7b26)\u7ec4\u5408\u5b57\u7b26\u4e32!");
            }
            return String.format(CIPHER_FORMAT, Des3Utils.des3EncodeCBCString(key, data));
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25! key={},data={}", new Object[]{key, data, e});
            throw new BusinessRuntimeException("\u52a0\u5bc6\u5931\u8d25!", (Throwable)e);
        }
    }

    public static String decode(String key, String data) {
        logger.debug("\u89e3\u5bc6\u65b9\u6cd5! key={},data={}", (Object)key, (Object)data);
        try {
            if (StringUtils.isBlank((CharSequence)data)) {
                return data;
            }
            if (!StringUtils.isBlank((CharSequence)key) && key.length() < 24) {
                throw new BusinessRuntimeException("\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e24\u4e2a(\u82f1\u6587/\u6570\u5b57/\u7279\u6b8a\u5b57\u7b26)\u7ec4\u5408\u5b57\u7b26\u4e32!");
            }
            Matcher matcher = PATTERN.matcher(data);
            String context = data;
            while (matcher.find()) {
                if (StringUtils.isBlank((CharSequence)key)) {
                    context = context.replace(matcher.group(0), Des3Utils.des3DecodeCBCString(DEFAULT_KEY, matcher.group(1)));
                    continue;
                }
                context = context.replace(matcher.group(0), Des3Utils.des3DecodeCBCString(key, matcher.group(1)));
            }
            return context;
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u5931\u8d25! key={},data={}", new Object[]{key, data, e});
            throw new BusinessRuntimeException("\u89e3\u5bc6\u5931\u8d25!", (Throwable)e);
        }
    }
}

