/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.WeiXinApi;
import com.dtyunxi.vo.AccessToken;
import com.dtyunxi.vo.Authorization;
import com.dtyunxi.vo.JsapiTicket;
import com.dtyunxi.vo.UserInfo;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiXinUtil {
    private static final Logger logger = LoggerFactory.getLogger(WeiXinUtil.class);

    public static AccessToken getAccessToken(String appId, String appsecret) {
        String url = WeiXinApi.getTokenUrl(appId, appsecret);
        String json = HttpUtil.sendGet(url);
        logger.info(json);
        AccessToken accessToken = null;
        try {
            accessToken = (AccessToken)JacksonUtil.readValue((String)json, AccessToken.class);
        }
        catch (Exception e) {
            logger.info("accessToken-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return accessToken;
    }

    public static JsapiTicket getJsapiTicket(String token) {
        String url = WeiXinApi.getJsApiTicketUrl(token);
        String json = HttpUtil.sendGet(url);
        logger.info(json);
        JsapiTicket jsapiTicket = null;
        try {
            jsapiTicket = (JsapiTicket)JacksonUtil.readValue((String)json, JsapiTicket.class);
        }
        catch (Exception e) {
            logger.info("JsapiTicket-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return jsapiTicket;
    }

    public static UserInfo getOAuthUserinfo(String openid, String oAuthToken) {
        String ticketJson = HttpUtil.sendGet(WeiXinApi.getOAuthUserinfoUrl(oAuthToken, openid));
        logger.info(ticketJson);
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)JacksonUtil.readValue((String)ticketJson, UserInfo.class);
        }
        catch (Exception e) {
            logger.info("UserInfo-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return userInfo;
    }

    public static UserInfo getUserInfo(String openid, String token) {
        String ticketJson = HttpUtil.sendGet(WeiXinApi.getUserinfoUrl(token, openid));
        logger.info(ticketJson);
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)JacksonUtil.readValue((String)ticketJson, UserInfo.class);
        }
        catch (Exception e) {
            logger.info("UserInfo-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return userInfo;
    }

    public static Boolean checkAccessToken(String openid, String token) {
        boolean bool = false;
        String result = HttpUtil.sendGet(WeiXinApi.getCheckOauthToken(token, openid));
        JSONObject jsonObject = JSON.parseObject((String)result);
        int errcode = Integer.parseInt(jsonObject.getString("errcode"));
        if (errcode == 0) {
            bool = true;
        }
        return bool;
    }

    public static Authorization getAuthorization(String appId, String appsecret, String code) {
        String json = HttpUtil.sendGet(WeiXinApi.getOAuthTokenUrl(appId, appsecret, code));
        logger.info(json);
        Authorization authorization = null;
        try {
            authorization = (Authorization)JacksonUtil.readValue((String)json, Authorization.class);
        }
        catch (Exception e) {
            logger.info("Authorization-json\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return authorization;
    }

    public static Map<String, String> sign(String jsapi_ticket, String url, String APPID) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String nonceStr = WeiXinUtil.create_nonce_str();
        String timestamp = WeiXinUtil.create_timestamp();
        String plain = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
        logger.info(plain);
        String signature = WeiXinUtil.getSHA1(plain);
        ret.put("url", url);
        ret.put("jsapi_ticket", jsapi_ticket);
        ret.put("nonceStr", nonceStr);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        ret.put("appId", APPID);
        return ret;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16);
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static String getSHA1(String decript) {
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(decript.getBytes(StandardCharsets.UTF_8));
            return WeiXinUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u7b7e\u540d\u51fa\u9519\uff01", (Throwable)e);
            return "";
        }
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

