/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.model;

import java.util.Objects;
import org.springframework.util.StringUtils;

public class Version {
    private String major;
    private String minor;
    private String patch;

    public Version() {
    }

    public Version(String major, String minor, String patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public String getMajor() {
        return this.major;
    }

    public void setMajor(String major) {
        this.major = major;
    }

    public String getMinor() {
        return this.minor;
    }

    public void setMinor(String minor) {
        this.minor = minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("  \"major\":\"").append(this.major).append('\"');
        sb.append(", \"minor\":\"").append(this.minor).append('\"');
        sb.append(", \"patch\":\"").append(this.patch).append('\"');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major) && Objects.equals(this.minor, version.minor) && Objects.equals(this.patch, version.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public static Version of(String version) {
        if (!StringUtils.isEmpty((Object)version)) {
            String[] versions = version.split("\\.");
            return new Version(versions[0], versions[1], versions[2]);
        }
        return null;
    }
}

