/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.model.context;

import cn.hutool.core.codec.Base64Decoder;
import com.dtyunxi.huieryun.core.model.Application;
import com.dtyunxi.huieryun.core.model.context.Operator;
import com.dtyunxi.huieryun.core.model.context.RequestContext;
import com.dtyunxi.huieryun.core.util.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RequestContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(RequestContextHolder.class);
    private static final ThreadLocal<Operator> tlOperator = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> tlContext = new ThreadLocal();
    private static final ThreadLocal<String> tlTraceId = new ThreadLocal();
    private static final ThreadLocal<Application> tlApplication = new ThreadLocal();
    private static final SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String KEY_GTMC_REQUEST = "GTMC-REQUEST";

    public static void build(HttpServletRequest request, Application application) {
        String strRequest = request.getHeader(KEY_GTMC_REQUEST);
        if (!StringUtils.isEmpty((Object)strRequest)) {
            RequestContext gtmcRequest = JSON.parseObject(new String(Base64Decoder.decode((CharSequence)strRequest)), RequestContext.class);
            tlOperator.set(gtmcRequest.getOperator());
            tlTraceId.set(gtmcRequest.getTraceId());
            tlApplication.set(application);
            tlContext.set(gtmcRequest.getContext());
        } else {
            Operator client = RequestContextHolder.buildOperator(request);
            tlOperator.set(client);
            tlTraceId.set(UUID.randomUUID().toString());
            tlApplication.set(application);
            tlContext.set(new HashMap());
        }
    }

    public static void clean() {
        tlContext.remove();
        tlOperator.remove();
    }

    public static Operator getOperator() {
        return tlOperator.get();
    }

    public static String getTraceId() {
        return tlTraceId.get();
    }

    public static Application getApplication() {
        return tlApplication.get();
    }

    public static Map<String, Object> getContext() {
        return tlContext.get();
    }

    public static <T> T get(String name, Class<T> clazz, T defVal) {
        Map<String, Object> context = tlContext.get();
        if (context == null) {
            return defVal;
        }
        if (name == null) {
            return defVal;
        }
        Object objVal = context.get(name);
        if (objVal == null) {
            return defVal;
        }
        if (clazz.isAssignableFrom(objVal.getClass())) {
            return (T)objVal;
        }
        try {
            String clazzName = clazz.getName();
            String strVal = objVal.toString().trim();
            if (clazzName.equals(String.class.getName())) {
                objVal = String.valueOf(strVal);
            } else if (clazzName.equals(Integer.class.getName())) {
                objVal = Integer.parseInt(strVal);
            } else if (clazzName.equals(Long.class.getName())) {
                objVal = Long.parseLong(strVal);
            } else if (clazzName.equals(Float.class.getName())) {
                objVal = Float.valueOf(Float.parseFloat(strVal));
            } else if (clazzName.equals(Double.class.getName())) {
                objVal = Double.parseDouble(strVal);
            } else if (clazzName.equals(Boolean.class.getName())) {
                objVal = Boolean.parseBoolean(strVal);
            } else if (clazzName.equals(Date.class.getName())) {
                objVal = strVal.length() > 10 ? longFormat.parse(strVal) : shortFormat.parse(strVal);
            } else {
                return defVal;
            }
            return (T)objVal;
        }
        catch (Throwable t) {
            logger.warn("Get value failed for name {} and type {}, will use default value {}!", new Object[]{name, clazz, defVal});
            logger.error("Original error is {}", (Object)t.getMessage(), (Object)t);
            return defVal;
        }
    }

    public static <T> void put(String name, T value) {
        Map<String, Object> context = tlContext.get();
        if (context == null) {
            context = new HashMap<String, Object>();
            context.put(name, value);
            tlContext.set(context);
        } else {
            context.put(name, value);
        }
    }

    private static Operator buildOperator(HttpServletRequest request) {
        String jwt = request.getHeader("GTMC_JWT");
        if (!StringUtils.isEmpty((Object)jwt)) {
            String encodeClaims = jwt.trim().split("\\.")[1];
            Map claims = JSON.parseObject(new String(Base64Decoder.decode((CharSequence)encodeClaims)), Map.class);
            return Operator.of((String)claims.get("ID"), (String)claims.get("CODE"), (String)claims.get("NAME"));
        }
        String strOperator = request.getHeader("GTMC_OPERATOR");
        if (StringUtils.isEmpty((Object)strOperator)) {
            return Operator.of(null, null, null);
        }
        return JSON.parseObject(new String(Base64Decoder.decode((CharSequence)strOperator.trim())), Operator.class);
    }
}

