/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;

public class CustomDateSerializer
extends JsonSerializer<Date> {
    private DateFormat customFormat;
    @Value(value="${spring.jackson.useTimestamp:false}")
    private boolean useTimestamp = false;
    public static final CustomDateSerializer instance = new CustomDateSerializer();

    public void serialize(Date date, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new DateSerializer(Boolean.valueOf(this.useTimestamp), this.getCustomFormat()).serialize(date, gen, serializers);
    }

    @Value(value="${spring.jackson.dateFormat}")
    public void setDateFormat(String dateFormat) {
        this.customFormat = new SimpleDateFormat(dateFormat);
    }

    public DateFormat getCustomFormat() {
        if (this.customFormat == null) {
            this.customFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.customFormat;
    }
}

